/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IDescriptionHelper;

public final class SelectSupport {
    private final ObjectInfo m_rootObject;
    private final IEditPartViewer m_graphicalViewer;
    private final IEditPartViewer m_treeViewer;
    private final Set<ObjectInfo> m_selectedObjects = Sets.newHashSet();
    private final Set<ObjectInfo> m_selectingSet = Sets.newLinkedHashSet();
    private final Listener m_keyListener = new Listener(){

        public void handleEvent(Event event) {
            int cmdModifierValue = SelectSupport.getCommandModifierValue();
            if (event.keyCode == 97 && event.stateMask == cmdModifierValue) {
                SelectSupport.this.selectAll();
            }
            if (event.keyCode == 97 && event.stateMask == (cmdModifierValue | 0x20000)) {
                SelectSupport.this.selectSameType();
            }
            if (event.keyCode == 97 && event.stateMask == (cmdModifierValue | 0x10000)) {
                SelectSupport.this.selectSameParent();
            }
        }
    };

    public SelectSupport(ObjectInfo rootObject, IEditPartViewer graphicalViewer, IEditPartViewer treeViewer) {
        this.m_rootObject = rootObject;
        this.m_graphicalViewer = graphicalViewer;
        this.m_treeViewer = treeViewer;
        this.addKeyDownListener(this.m_graphicalViewer);
        this.addKeyDownListener(this.m_treeViewer);
        rootObject.addBroadcastListener(new ObjectEventListener(){

            @Override
            public void dispose() throws Exception {
                SelectSupport.this.removeKeyDownListener(SelectSupport.this.m_graphicalViewer);
                SelectSupport.this.removeKeyDownListener(SelectSupport.this.m_treeViewer);
            }

            @Override
            public void addContextMenu(List<? extends ObjectInfo> selectedObjects, ObjectInfo object, IMenuManager manager) throws Exception {
                SelectSupport.this.contributeActions(manager);
            }
        });
    }

    private void addKeyDownListener(IEditPartViewer viewer) {
        Control control = viewer.getControl();
        control.addListener(1, this.m_keyListener);
    }

    private void removeKeyDownListener(IEditPartViewer viewer) {
        Control control = viewer.getControl();
        if (!control.isDisposed()) {
            control.removeListener(1, this.m_keyListener);
        }
    }

    private static int getCommandModifierValue() {
        return EnvironmentUtils.IS_MAC ? 0x400000 : 262144;
    }

    private static String getCommandModifierName() {
        return EnvironmentUtils.IS_MAC ? "Cmd" : "Ctrl";
    }

    private void selectAll() {
        this.doBeforeSelect();
        this.m_rootObject.accept(new ObjectInfoVisitor(){

            public boolean visit(ObjectInfo object) throws Exception {
                SelectSupport.this.m_selectingSet.add(object);
                return true;
            }
        });
        this.selectByModels();
    }

    private void selectSameType() {
        this.doBeforeSelect();
        final IDescriptionHelper descriptionHelper = GlobalState.getDescriptionHelper();
        for (ObjectInfo selectedObject : this.m_selectedObjects) {
            IComponentDescription selectedDescription = descriptionHelper.getDescription(selectedObject);
            if (selectedDescription == null) continue;
            final Class<?> selectedClass = selectedDescription.getComponentClass();
            this.m_rootObject.accept(new ObjectInfoVisitor(){

                public boolean visit(ObjectInfo object) throws Exception {
                    IComponentDescription description = descriptionHelper.getDescription(object);
                    if (description != null && description.getComponentClass() == selectedClass) {
                        SelectSupport.this.m_selectingSet.add(object);
                    }
                    return true;
                }
            });
        }
        this.selectByModels();
    }

    private void selectSameParent() {
        this.doBeforeSelect();
        for (ObjectInfo selectedObject : this.m_selectedObjects) {
            ObjectInfo selectedParent = selectedObject.getParent();
            if (selectedParent == null) continue;
            this.m_selectingSet.addAll(selectedParent.getChildren());
        }
        this.selectByModels();
    }

    private void doBeforeSelect() {
        this.m_selectingSet.clear();
        this.m_selectedObjects.clear();
        List<EditPart> selectedEditParts = this.m_graphicalViewer.getSelectedEditParts();
        for (EditPart editPart : selectedEditParts) {
            Object model = editPart.getModel();
            if (!(model instanceof ObjectInfo)) continue;
            this.m_selectedObjects.add((ObjectInfo)model);
        }
    }

    private void selectByModels() {
        List editParts = Lists.newArrayList();
        for (ObjectInfo object : this.m_selectingSet) {
            EditPart editPart = this.m_graphicalViewer.getEditPartByModel(object);
            if (editPart == null) continue;
            editParts.add(editPart);
        }
        this.m_graphicalViewer.setSelection(editParts);
    }

    public void contributeActions(IMenuManager manager) {
        MenuManager selectMenuManager = new MenuManager("Select");
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IContributionItem)selectMenuManager);
        String cmdModifierName = SelectSupport.getCommandModifierName();
        String text = MessageFormat.format("All\t{0}+A", cmdModifierName);
        selectMenuManager.add((IAction)new SelectAction(text, "all.png"){

            protected void runEx() throws Exception {
                SelectSupport.this.selectAll();
            }
        });
        text = MessageFormat.format("All of Same Type\t{0}+Shift+A", cmdModifierName);
        selectMenuManager.add((IAction)new SelectAction(text, "sameType.png"){

            protected void runEx() throws Exception {
                SelectSupport.this.selectSameType();
            }
        });
        text = MessageFormat.format("All on Same Parent\t{0}+Alt+A", cmdModifierName);
        selectMenuManager.add((IAction)new SelectAction(text, "sameParent.png"){

            protected void runEx() throws Exception {
                SelectSupport.this.selectSameParent();
            }
        });
    }

    private abstract class SelectAction
    extends ObjectInfoAction {
        public SelectAction(String text, String imageName) {
            super(SelectSupport.this.m_rootObject);
            this.setText(text);
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/select/" + imageName));
        }
    }
}

