/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.controls.palette.IPalettePreferences;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

public final class PluginPalettePreferences
implements IPalettePreferences {
    private final IPreferenceStore m_store;
    private Font m_categoryFont;
    private Font m_entryFont;
    private String m_categoryFontKey;
    private String m_entryFontKey;
    private String m_onlyIconsKey;
    private String m_minColumnsKey;

    public PluginPalettePreferences(IPreferenceStore store) {
        this.m_store = store;
    }

    public void setPrefix(String prefix) {
        this.m_categoryFontKey = String.valueOf(prefix) + ".category.font";
        this.m_entryFontKey = String.valueOf(prefix) + ".entry.font";
        this.m_onlyIconsKey = String.valueOf(prefix) + ".onlyIcons";
        this.m_minColumnsKey = String.valueOf(prefix) + ".columns.min";
        FontData[] defaultFontData = Display.getDefault().getSystemFont().getFontData()[0];
        FontData boldFontData = new FontData(defaultFontData.getName(), defaultFontData.getHeight(), 1);
        PreferenceConverter.setDefault((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey, (FontData)boldFontData);
        defaultFontData = Display.getDefault().getSystemFont().getFontData();
        PreferenceConverter.setDefault((IPreferenceStore)this.m_store, (String)this.m_entryFontKey, (FontData[])defaultFontData);
        this.m_store.setDefault(this.m_onlyIconsKey, false);
        this.m_store.setDefault(this.m_minColumnsKey, 2);
    }

    public Font getCategoryFont() {
        if (this.m_categoryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey);
            this.m_categoryFont = SwtResourceManager.getFont(fontDataArray);
        }
        return this.m_categoryFont;
    }

    public Font getEntryFont() {
        if (this.m_entryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.m_store, (String)this.m_entryFontKey);
            this.m_entryFont = SwtResourceManager.getFont(fontDataArray);
        }
        return this.m_entryFont;
    }

    public boolean isOnlyIcons() {
        return this.m_store.getBoolean(this.m_onlyIconsKey);
    }

    public int getMinColumns() {
        return this.m_store.getInt(this.m_minColumnsKey);
    }

    public void setCategoryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey, (FontData[])fontDataArray);
    }

    public void setEntryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.m_store, (String)this.m_entryFontKey, (FontData[])fontDataArray);
    }

    public void setOnlyIcons(boolean onlyIcons) {
        this.m_store.setValue(this.m_onlyIconsKey, onlyIcons);
    }

    public void setMinColumns(int minColumns) {
        this.m_store.setValue(this.m_minColumnsKey, minColumns);
    }
}

