/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutDescriptionHelper {
    private static final String POINT_ID = "org.eclipse.wb.core.layoutManagers";
    private static final Map<ToolkitDescription, List<LayoutDescription>> m_layouts = Maps.newHashMap();

    private LayoutDescriptionHelper() {
    }

    public static List<LayoutDescription> get(ToolkitDescription toolkit) {
        List layouts = m_layouts.get(toolkit);
        if (layouts == null) {
            layouts = Lists.newArrayList();
            m_layouts.put(toolkit, layouts);
            for (IConfigurationElement element : ExternalFactoriesHelper.getElements(POINT_ID, "layout")) {
                String toolkitId = ExternalFactoriesHelper.getRequiredAttribute(element, "toolkit");
                if (!toolkitId.equals(toolkit.getId())) continue;
                layouts.add(new LayoutDescription(toolkit, element));
            }
        }
        return layouts;
    }

    public static LayoutDescription get(ToolkitDescription toolkit, String id) {
        for (LayoutDescription layout : LayoutDescriptionHelper.get(toolkit)) {
            if (!layout.getId().equals(id)) continue;
            return layout;
        }
        return null;
    }
}

