/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class FieldUniqueVariableSupport
extends FieldVariableSupport {
    private static final String BASE = "variable.fieldUnique.";
    public static final String P_PREFIX_THIS = "variable.fieldUnique.prefixThis";
    public static final String P_FIELD_MODIFIER = "variable.fieldUnique.fieldModifier";

    public FieldUniqueVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public FieldUniqueVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo, variable);
    }

    public String toString() {
        return "field-unique: " + this.getName();
    }

    public void setName(String newName) throws Exception {
        this.modifyName(newName);
    }

    public boolean canConvertFieldToLocal() {
        Set methods = Sets.newHashSet();
        for (Expression reference : this.getReferences()) {
            MethodDeclaration method;
            if (reference.getParent() instanceof VariableDeclarationFragment || (method = AstNodeUtils.getEnclosingMethod((ASTNode)reference)) == null) continue;
            methods.add(method);
        }
        return methods.size() == 1;
    }

    public void convertFieldToLocal() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        VariableDeclaration oldFragment = this.m_declaration;
        FieldDeclaration oldField = (FieldDeclaration)oldFragment.getParent();
        String typeString = editor.getSource((ASTNode)oldField.getType());
        Assignment assignment = (Assignment)this.m_variable.getParent();
        Assert.isTrue(assignment.getLeftHandSide() == this.m_variable);
        Expression oldInitializer = assignment.getRightHandSide();
        Statement oldStatement = (Statement)assignment.getParent();
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(oldField.getType());
        String localName = this.m_utils.convertName(assignment.getStartPosition(), this.getName(), "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes", "org.eclipse.jdt.core.codeComplete.localPrefixes", "org.eclipse.jdt.core.codeComplete.localSuffixes", this.m_declaration);
        this.setName(localName);
        for (Expression reference : this.getReferences()) {
            if (!(reference instanceof FieldAccess)) continue;
            SimpleName simpleReference = this.parseVariableSimpleName(reference.getStartPosition(), localName, typeBinding);
            editor.replaceSubstring((ASTNode)reference, localName);
            AstEditor.replaceNode((ASTNode)reference, (ASTNode)simpleReference);
            if (reference != this.m_variable) continue;
            this.m_variable = simpleReference;
        }
        int oldStart = this.m_variable.getStartPosition();
        editor.replaceSubstring(oldStart, 0, String.valueOf(typeString) + " ");
        Type newType = editor.getParser().parseType(oldStart, oldField.getType());
        AST ast = this.m_variable.getAST();
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        assignment.setLeftHandSide((Expression)ast.newSimpleName("__foo"));
        editor.replaceSubstring((ASTNode)this.m_variable, localName);
        SimpleName localVariable = this.parseVariableSimpleName(this.m_variable.getStartPosition(), localName, typeBinding);
        this.m_variable = localVariable;
        newFragment.setName(localVariable);
        assignment.setRightHandSide((Expression)ast.newSimpleName("__bar"));
        newFragment.setInitializer(oldInitializer);
        AstNodeUtils.setSourceRange((ASTNode)newFragment, (ASTNode)this.m_variable, (ASTNode)oldInitializer);
        VariableDeclarationStatement newStatement = ast.newVariableDeclarationStatement(newFragment);
        newStatement.setType(newType);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newType, (ASTNode)oldStatement);
        List<Statement> statements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = statements.indexOf(oldStatement);
        statements.set(index, (Statement)newStatement);
        editor.removeVariableDeclaration(oldFragment);
        this.m_javaInfo.setVariableSupport(new LocalUniqueVariableSupport(this.m_javaInfo, localVariable));
    }

    private SimpleName parseVariableSimpleName(int position, String localName, ITypeBinding typeBinding) {
        AstEditor editor = this.m_javaInfo.getEditor();
        return editor.getParser().parseVariable(position, localName, null, typeBinding, false, 0);
    }

    public String add_getVariableStatementSource(StatementTarget associationTarget) throws Exception {
        boolean isStatic = this.isStaticContext(associationTarget.getPosition());
        String name = NamesManager.getName(this.m_javaInfo);
        String fieldName = this.m_utils.getUniqueFieldName(name, null);
        String modifiers = FieldUniqueVariableSupport.perfFieldModifier(this.m_javaInfo);
        if (isStatic) {
            modifiers = String.valueOf(modifiers) + "static ";
        }
        String className = this.m_javaInfo.getDescription().getComponentClass().getName();
        this.addField(String.valueOf(modifiers) + className + " " + fieldName + ";");
        String fieldReference = fieldName;
        if (!isStatic && this.prefixThis()) {
            fieldReference = "this." + fieldName;
        }
        NodeTarget creationTarget = new NodeTarget(associationTarget);
        String initializer = this.m_javaInfo.getCreationSupport().add_getSource(creationTarget);
        initializer = StringUtils.replace((String)initializer, (String)"%variable-name%", (String)fieldName);
        return String.valueOf(fieldReference) + " = " + initializer + ";";
    }

    public void add_setVariableStatement(Statement statement) throws Exception {
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Assignment assignment = (Assignment)expressionStatement.getExpression();
        this.add_setVariableAndInitializer(assignment.getLeftHandSide(), assignment.getRightHandSide());
    }

    public void deleteAfter() throws Exception {
        if (this.m_javaInfo.isRoot()) {
            return;
        }
        this.delete_removeDeclarationField();
    }

    public void setType(String newTypeName) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        editor.replaceVariableType(this.m_declaration, newTypeName);
    }

    protected boolean prefixThis() {
        return this.getPreferences().getBoolean(P_PREFIX_THIS);
    }

    public static String perfFieldModifier(JavaInfo javaInfo) {
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        return V_MODIFIER_CODE[preferences.getInt(P_FIELD_MODIFIER)];
    }
}

