/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.product;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;
import org.osgi.framework.Version;

public final class ProductInfo {
    private static final String[] CORE_PRODUCT = new String[]{"org.eclipse.wb.core"};
    private static final String[] SWTD_PRODUCT = new String[]{"org.eclipse.wb.swt"};
    private static final String[] SWINGD_PRODUCT = new String[]{"org.eclipse.wb.swing"};
    private static final String[] GWTD_PRODUCT = new String[]{"com.google.gdt.eclipse.designer"};
    private static final String[] ERCP_PRODUCT = new String[]{"org.eclipse.wb.ercp"};
    private static final String UNKNOWN_BUILD = "UNKNOWN";
    private static final String ECLIPSE_VERSION_KEY = "eclipse.version";
    private static final String TARGET_PROPERTIES = "target.properties";
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String BUILD_KEY = "build";
    private static final String GRACE_GIVEN = ".graceGiven";
    private static final String DEVELOPMENT_BUILD_NUM = "201209161109";
    private static final String DOT_INTERNAL = ".internal";
    private final String[] product_info;
    private static ProductInfo INSTANCE;
    private Version version;
    private String build;
    private static String startTimeString;

    private ProductInfo() {
        boolean isInstalledGWT;
        boolean isInstalledERCP = Platform.getBundle((String)ERCP_PRODUCT[0]) != null;
        boolean isInstalledSWT = Platform.getBundle((String)SWTD_PRODUCT[0]) != null;
        boolean isInstalledSwing = Platform.getBundle((String)SWINGD_PRODUCT[0]) != null;
        boolean bl = isInstalledGWT = Platform.getBundle((String)GWTD_PRODUCT[0]) != null;
        this.product_info = isInstalledSWT && isInstalledSwing ? CORE_PRODUCT : (isInstalledSWT ? SWTD_PRODUCT : (isInstalledSwing ? SWINGD_PRODUCT : (isInstalledGWT ? GWTD_PRODUCT : (isInstalledERCP ? ERCP_PRODUCT : CORE_PRODUCT))));
    }

    public String getPluginId() {
        return this.product_info[0];
    }

    public static ProductInfo getProduct() {
        if (INSTANCE == null) {
            INSTANCE = new ProductInfo();
        }
        return INSTANCE;
    }

    public Version getVersion() {
        boolean isEclipseRunning;
        if (this.version != null) {
            return this.version;
        }
        try {
            isEclipseRunning = Platform.isRunning();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.version = Version.emptyVersion;
            return this.version;
        }
        if (isEclipseRunning) {
            this.version = PluginUtilities.getVersion(this.getPluginId());
            return this.version;
        }
        this.version = Version.emptyVersion;
        return this.version;
    }

    public static boolean isInstalled(String pluginId) {
        return PluginUtilities.getInstallUrl(pluginId) != null;
    }

    public String getBuild() {
        boolean isEclipseRunning;
        if (this.build != null) {
            return this.build;
        }
        try {
            isEclipseRunning = Platform.isRunning();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.build = UNKNOWN_BUILD;
            return this.build;
        }
        if (isEclipseRunning) {
            this.build = ProductInfo.getPluginBuild(this.getPluginId());
            return this.build;
        }
        this.build = UNKNOWN_BUILD;
        return this.build;
    }

    public static String getPluginBuild(String pluginId) {
        URL url = PluginUtilities.getUrl(pluginId, PLUGIN_PROPERTIES);
        if (url != null) {
            String build;
            Properties properties;
            block17: {
                properties = new Properties();
                InputStream stream = null;
                try {
                    try {
                        stream = url.openStream();
                        properties.load(stream);
                    }
                    catch (IOException e) {
                        DesignerPlugin.log(e);
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block17;
                        }
                        catch (Exception e2) {
                            DesignerPlugin.log(e2);
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        DesignerPlugin.log(e);
                    }
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    DesignerPlugin.log(e);
                }
            }
            if ((build = properties.getProperty(BUILD_KEY)) == null || build.equals(DEVELOPMENT_BUILD_NUM)) {
                return ProductInfo.getStartDateTimeString();
            }
            if (build.length() > 0) {
                return build;
            }
        }
        return UNKNOWN_BUILD;
    }

    public static String getStartDateTimeString() {
        if (startTimeString == null) {
            startTimeString = ProductInfo.getCurrentDateTimeString();
        }
        return startTimeString;
    }

    public static String getCurrentDateTimeString() {
        return new SimpleDateFormat("yyyyMMddHHmm").format(new GregorianCalendar().getTime());
    }
}

