/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.core.WBToolkitRegistry;
import org.eclipse.wb.internal.discovery.ui.Messages;
import org.eclipse.wb.internal.discovery.ui.WBDiscoveryUiPlugin;
import org.eclipse.wb.internal.discovery.ui.wizard.InstallToolkitWizardPage;

public class InstallToolkitWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private String toolkitId;
    private WBToolkit toolkit;
    private InstallToolkitWizardPage page;

    public InstallToolkitWizard() {
        this.setWindowTitle(Messages.InstallToolkitWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.toolkitId = (String)data;
            this.toolkit = WBToolkitRegistry.getRegistry().getToolkit(this.toolkitId);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.toolkit != null) {
            this.setWindowTitle(MessageFormat.format(Messages.InstallToolkitWizard_titlePattern, this.toolkit.getName()));
        }
    }

    public void addPages() {
        this.page = new InstallToolkitWizardPage(this.toolkit);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        block3: {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            WBDiscoveryUiPlugin.getPlugin().installToolkits(Collections.singletonList(InstallToolkitWizard.this.toolkit), monitor);
                        }
                        catch (ProvisionException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof OperationCanceledException) break block3;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.InstallToolkitWizard_errorInstalling, (String)e.getCause().getMessage());
            }
        }
        return true;
    }
}

