/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.MigLayout.gef.MigGridHelper;
import org.eclipse.wb.internal.swing.MigLayout.gef.MigLayoutSplitEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.gef.MigSelectionEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.RowHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.layout.ColumnsLayoutEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.layout.RowsLayoutEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.gef.ComponentsLayoutRequestValidator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayoutEditPolicy
extends AbstractGridLayoutEditPolicy {
    private final MigLayoutInfo m_layout;
    public static final String SECONDARY_SELECTION_FEEDBACK_ROLE = "Secondary Selection Feedback";
    private LayoutEditPolicy m_flowPolicy;
    private Command m_flowCommand;

    public MigLayoutEditPolicy(MigLayoutInfo layout) {
        super((ObjectInfo)layout);
        this.m_layout = layout;
        this.m_gridTargetHelper = new MigGridHelper((GraphicalEditPolicy)this, true);
        this.m_gridSelectionHelper = new MigGridHelper((GraphicalEditPolicy)this, false);
        new BroadcastListenerHelper((ObjectInfo)layout, (EditPolicy)this, (Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                MigLayoutEditPolicy.this.decorateChildren();
            }
        });
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ComponentsLayoutRequestValidator.INSTANCE_EXT;
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    private void decorateChildren() {
        for (EditPart child : this.getHost().getChildren()) {
            this.decorateChild(child);
        }
    }

    protected void decorateChild(EditPart child) {
        if (child.getModel() instanceof ComponentInfo) {
            ComponentInfo component = (ComponentInfo)child.getModel();
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            if (constraints.getDockSide() == null) {
                MigLayoutEditPolicy.setSelectionEditPolicy(child, (SelectionEditPolicy)new MigSelectionEditPolicy(this.m_layout, component));
                if (this.m_layout.getCellComponents(constraints.getX(), constraints.getY()).size() > 1) {
                    child.installEditPolicy((Object)SECONDARY_SELECTION_FEEDBACK_ROLE, (EditPolicy)new NonResizableSelectionEditPolicy());
                } else {
                    child.installEditPolicy((Object)SECONDARY_SELECTION_FEEDBACK_ROLE, null);
                }
            } else {
                MigLayoutEditPolicy.setSelectionEditPolicy(child, (SelectionEditPolicy)new NonResizableSelectionEditPolicy());
            }
        }
    }

    private static void setSelectionEditPolicy(EditPart child, SelectionEditPolicy selectionPolicy) {
        EditPolicy oldPolicy = child.getEditPolicy((Object)"Selection Feedback");
        if (oldPolicy == null || oldPolicy.getClass() != selectionPolicy.getClass()) {
            child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)selectionPolicy);
        }
    }

    protected boolean showOccupiedLayoutTargetFeedback(Request request) {
        if (this.m_flowPolicy == null) {
            this.m_flowPolicy = new MigLayoutSplitEditPolicy(this.m_layout, this.m_target.m_column, this.m_target.m_row);
            this.m_flowPolicy.setHost((EditPart)this.getHost());
        }
        this.m_flowPolicy.showTargetFeedback(request);
        this.m_flowCommand = this.m_flowPolicy.getCommand(request);
        return true;
    }

    protected void eraseOccupiedLayoutTargetFeedback(Request request) {
        if (this.m_flowPolicy != null) {
            this.m_flowPolicy.eraseTargetFeedback(request);
            this.m_flowPolicy.setHost(null);
            this.m_flowPolicy = null;
            this.m_flowCommand = null;
        }
    }

    private boolean isValidTarget() {
        if (!this.m_target.m_valid) {
            return false;
        }
        if (!this.m_layout.canChangeDimensions()) {
            if (this.m_target.m_columnInsert || this.m_target.m_rowInsert) {
                return false;
            }
            if (this.m_target.m_column >= this.m_layout.getColumns().size() || this.m_target.m_row >= this.m_layout.getRows().size()) {
                return false;
            }
        }
        return true;
    }

    public Command getCommand(Request request) {
        if (this.m_flowCommand != null) {
            return this.m_flowCommand;
        }
        return super.getCommand(request);
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObject;
        if (this.isValidTarget() && (newObject = request.getNewObject()) instanceof ComponentInfo) {
            final ComponentInfo component = (ComponentInfo)newObject;
            return new EditCommand((ObjectInfo)this.m_layout){

                protected void executeEdit() throws Exception {
                    MigLayoutEditPolicy.this.m_layout.command_CREATE(component, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_column, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_columnInsert, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_row, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getPasteCommand(PasteRequest request) {
        List mementos = (List)request.getMemento();
        if (this.isValidTarget() && mementos.size() == 1) {
            return LayoutPolicyUtils.getPasteCommand((JavaInfo)this.m_layout, (PasteRequest)request, ComponentInfo.class, (LayoutPolicyUtils.IPasteProcessor)new LayoutPolicyUtils.IPasteProcessor<ComponentInfo>(){

                public void process(ComponentInfo component) throws Exception {
                    MigLayoutEditPolicy.this.m_layout.command_CREATE(component, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_column, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_columnInsert, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_row, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            });
        }
        return null;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        EditPart moveEditPart;
        if (this.isValidTarget() && request.getEditParts().size() == 1 && (moveEditPart = (EditPart)request.getEditParts().get(0)).getModel() instanceof ComponentInfo) {
            final ComponentInfo component = (ComponentInfo)moveEditPart.getModel();
            return new EditCommand((ObjectInfo)this.m_layout){

                protected void executeEdit() throws Exception {
                    MigLayoutEditPolicy.this.m_layout.command_MOVE(component, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_column, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_columnInsert, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_row, ((MigLayoutEditPolicy)MigLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        return this.getMoveCommand(request);
    }

    public static int[] getInsertFeedbackParameters(Interval interval, Interval nextInterval, int minGap) {
        int b;
        int gap = nextInterval.begin - interval.end();
        int visualGap = Math.max(gap, minGap);
        int a = interval.end();
        int x1_2 = a + (b = nextInterval.begin) - visualGap;
        int x1 = x1_2 % 2 == 0 ? x1_2 / 2 : x1_2 / 2 - 1;
        int x2 = a + b - x1;
        if (x1 == a - 1) {
            // empty if block
        }
        return new int[]{visualGap, --x1, ++x2, x1 - minGap, x2 + minGap};
    }

    protected void updateGridTarget(Point mouseLocation) throws Exception {
        int[] parameters;
        boolean nearBegin;
        boolean nearEnd;
        boolean narrowGap;
        boolean directGap;
        int[] parameters2;
        Interval nextInterval;
        Interval interval;
        boolean isLast;
        this.m_target = new AbstractGridLayoutEditPolicy.GridTarget();
        Point location = mouseLocation.getCopy();
        PolicyUtils.translateAbsoluteToModel((LayoutEditPolicy)this, (Translatable)location);
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int lastX = columnIntervals.length != 0 ? columnIntervals[columnIntervals.length - 1].end() : 0;
        int lastY = rowIntervals.length != 0 ? rowIntervals[rowIntervals.length - 1].end() : 0;
        this.m_target.m_rowInsertBounds.x = columnIntervals[0].begin - 5;
        this.m_target.m_rowInsertBounds.setRight(lastX + 5);
        this.m_target.m_columnInsertBounds.y = rowIntervals[0].begin - 5;
        this.m_target.m_columnInsertBounds.setBottom(lastY + 5);
        int columnIndex = 0;
        while (columnIndex < columnIntervals.length) {
            isLast = columnIndex == columnIntervals.length - 1;
            interval = columnIntervals[columnIndex];
            Interval interval2 = nextInterval = !isLast ? columnIntervals[columnIndex + 1] : null;
            if (location.x < columnIntervals[0].begin) {
                this.m_target.m_column = 0;
                this.m_target.m_columnInsert = true;
                parameters2 = MigLayoutEditPolicy.getInsertFeedbackParameters(new Interval(0, 0), interval, 7);
                this.m_target.m_feedbackBounds.x = parameters2[3];
                this.m_target.m_feedbackBounds.width = parameters2[4] - parameters2[3];
                this.m_target.m_columnInsertBounds.x = parameters2[1];
                this.m_target.m_columnInsertBounds.width = parameters2[2] - parameters2[1];
                break;
            }
            if (!isLast) {
                int gap = nextInterval.begin - interval.end();
                directGap = interval.end() <= location.x && location.x < nextInterval.begin;
                narrowGap = gap < 14;
                nearEnd = Math.abs(location.x - interval.end()) < 7;
                boolean bl = nearBegin = Math.abs(location.x - nextInterval.begin) < 7;
                if (directGap || narrowGap && (nearEnd || nearBegin)) {
                    this.m_target.m_column = columnIndex + 1;
                    this.m_target.m_columnInsert = true;
                    parameters = MigLayoutEditPolicy.getInsertFeedbackParameters(interval, nextInterval, 7);
                    this.m_target.m_feedbackBounds.x = parameters[3];
                    this.m_target.m_feedbackBounds.width = parameters[4] - parameters[3];
                    this.m_target.m_columnInsertBounds.x = parameters[1];
                    this.m_target.m_columnInsertBounds.width = parameters[2] - parameters[1];
                    break;
                }
            }
            if (interval.contains(location.x)) {
                this.m_target.m_column = columnIndex;
                this.m_target.m_feedbackBounds.x = interval.begin;
                this.m_target.m_feedbackBounds.width = interval.length + 1;
                break;
            }
            ++columnIndex;
        }
        if (this.m_target.m_column == -1) {
            int columnGap = gridInfo.getVirtualColumnGap();
            int columnSize = gridInfo.getVirtualColumnSize();
            int newWidth = columnSize + columnGap;
            int newDelta = (location.x - lastX - columnGap / 2) / newWidth;
            this.m_target.m_column = columnIntervals.length + newDelta;
            this.m_target.m_feedbackBounds.x = lastX + columnGap + newWidth * newDelta;
            this.m_target.m_feedbackBounds.width = columnSize + 1;
        }
        int rowIndex = 0;
        while (rowIndex < rowIntervals.length) {
            isLast = rowIndex == rowIntervals.length - 1;
            interval = rowIntervals[rowIndex];
            Interval interval3 = nextInterval = !isLast ? rowIntervals[rowIndex + 1] : null;
            if (location.y < rowIntervals[0].begin) {
                this.m_target.m_row = 0;
                this.m_target.m_rowInsert = true;
                parameters2 = MigLayoutEditPolicy.getInsertFeedbackParameters(new Interval(0, 0), interval, 5);
                this.m_target.m_feedbackBounds.y = parameters2[3];
                this.m_target.m_feedbackBounds.height = parameters2[4] - parameters2[3];
                this.m_target.m_rowInsertBounds.y = parameters2[1];
                this.m_target.m_rowInsertBounds.height = parameters2[2] - parameters2[1];
                break;
            }
            if (!isLast) {
                int gap = nextInterval.begin - interval.end();
                directGap = interval.end() <= location.y && location.y < nextInterval.begin;
                narrowGap = gap < 10;
                nearEnd = Math.abs(location.y - interval.end()) < 5;
                boolean bl = nearBegin = Math.abs(location.y - nextInterval.begin) < 5;
                if (directGap || narrowGap && (nearEnd || nearBegin)) {
                    this.m_target.m_row = rowIndex + 1;
                    this.m_target.m_rowInsert = true;
                    parameters = MigLayoutEditPolicy.getInsertFeedbackParameters(interval, nextInterval, 5);
                    this.m_target.m_feedbackBounds.y = parameters[3];
                    this.m_target.m_feedbackBounds.height = parameters[4] - parameters[3];
                    this.m_target.m_rowInsertBounds.y = parameters[1];
                    this.m_target.m_rowInsertBounds.height = parameters[2] - parameters[1];
                    break;
                }
            }
            if (interval.contains(location.y)) {
                this.m_target.m_row = rowIndex;
                this.m_target.m_feedbackBounds.y = interval.begin;
                this.m_target.m_feedbackBounds.height = interval.length + 1;
                break;
            }
            ++rowIndex;
        }
        if (this.m_target.m_row == -1) {
            int rowGap = gridInfo.getVirtualRowGap();
            int rowSize = gridInfo.getVirtualRowSize();
            int newHeight = rowSize + rowGap;
            int newDelta = (location.y - lastY - rowGap / 2) / newHeight;
            this.m_target.m_row = rowIntervals.length + newDelta;
            this.m_target.m_feedbackBounds.y = lastY + rowGap + newHeight * newDelta;
            this.m_target.m_feedbackBounds.height = rowSize + 1;
        }
    }

    public LayoutEditPolicy getContainerLayoutPolicy(boolean horizontal) {
        if (horizontal) {
            return new ColumnsLayoutEditPolicy(this, this.m_layout);
        }
        return new RowsLayoutEditPolicy(this, this.m_layout);
    }

    public List<?> getHeaders(boolean horizontal) {
        return horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
    }

    public EditPart createHeaderEditPart(boolean horizontal, Object model) {
        if (horizontal) {
            return new ColumnHeaderEditPart(this.m_layout, (MigColumnInfo)model, this.getHostFigure());
        }
        return new RowHeaderEditPart(this.m_layout, (MigRowInfo)model, this.getHostFigure());
    }

    public void buildContextMenu(IMenuManager manager, boolean horizontal) {
        if (horizontal) {
            manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.MigLayoutEditPolicy_appendColumn){

                protected void runEx() throws Exception {
                    int index = MigLayoutEditPolicy.this.m_layout.getColumns().size();
                    MigLayoutEditPolicy.this.m_layout.insertColumn(index);
                }
            });
        } else {
            manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.MigLayoutEditPolicy_appendRow){

                protected void runEx() throws Exception {
                    int index = MigLayoutEditPolicy.this.m_layout.getRows().size();
                    MigLayoutEditPolicy.this.m_layout.insertRow(index);
                }
            });
        }
    }

    public void handleDoubleClick(boolean horizontal) {
    }
}

