/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration
implements IInitializer {
    public Block block;
    public int lastVisibleFieldID;
    public int bodyStart;
    public int bodyEnd;
    public boolean errorInSignature = false;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.declarationSourceStart = this.sourceStart = block.sourceStart;
    }

    public FlowInfo analyseCode(MethodScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.block.analyseCode(currentScope, flowContext, flowInfo);
    }

    public int getKind() {
        return 2;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration unit) {
        parser.parse(this, typeDeclaration, unit);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.modifiers != 0) {
            Initializer.printIndent(indent, output);
            Initializer.printModifiers(this.modifiers, output);
            output.append("{\n");
            this.block.printBody(indent, output);
            Initializer.printIndent(indent, output).append('}');
            return output;
        }
        return this.block.printStatement(indent, output);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope scope) {
        FieldBinding previousField = scope.initializedField;
        int previousFieldID = scope.lastVisibleFieldID;
        try {
            scope.initializedField = null;
            scope.lastVisibleFieldID = this.lastVisibleFieldID;
            this.block.resolve(scope);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            scope.initializedField = previousField;
            scope.lastVisibleFieldID = previousFieldID;
            throw throwable;
        }
        {
            Object var4_6 = null;
            scope.initializedField = previousField;
            scope.lastVisibleFieldID = previousFieldID;
            return;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 47;
    }
}

