/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.gmf.glue.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.utils.DisplayUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.xtext.gmf.glue.contentassist.CustomCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public class CompletionProposalUtils {
    protected static final ILabelProvider labelProvider = DisplayUtils.getLabelProvider();

    public static CustomCompletionProposal createCompletionProposal(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n" + '(' + namedElement.eClass().getName() + ')';
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo, context);
        return completionProposal;
    }

    public static CustomCompletionProposal createCompletionProposalWithReplacementOfPrefix(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n" + '(' + namedElement.eClass().getName() + ')';
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset() - context.getPrefix().length(), context.getPrefix().length(), completionString.length(), labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo, context);
        return completionProposal;
    }

    public static CustomCompletionProposal createCompletionProposal(String completionString, String displayString, ContentAssistContext context) {
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), null, " " + displayString, null, null, context);
        return completionProposal;
    }

    public static String getQualifiedNameLabelWithSufficientDepth(NamedElement namedElement, Namespace model) {
        String label = "";
        ArrayList importedPackages = new ArrayList(model.getImportedPackages());
        ArrayList<Namespace> visitedNamespaces = new ArrayList<Namespace>();
        Namespace currentNamespace = namedElement.getNamespace();
        boolean rootFound = false;
        boolean modelIsTheRoot = false;
        while (currentNamespace != null && !rootFound) {
            visitedNamespaces.add(currentNamespace);
            if (importedPackages.contains(currentNamespace) || currentNamespace == model) {
                rootFound = true;
                if (currentNamespace == model) {
                    modelIsTheRoot = true;
                }
            }
            Element owner = currentNamespace.getOwner();
            while (owner != null && !(owner instanceof Namespace)) {
                owner = owner.getOwner();
            }
            Namespace namespace = currentNamespace = owner != null ? (Namespace)owner : null;
        }
        int i = visitedNamespaces.size() - 1 - (modelIsTheRoot ? 1 : 0);
        while (i >= 0) {
            label = String.valueOf(label) + ((Namespace)visitedNamespaces.get(i)).getName() + "::";
            --i;
        }
        return String.valueOf(label) + namedElement.getName();
    }
}

