/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.typing;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValueBinaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationValueArray;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.typing.XbaseTypeProvider;

@Singleton
public class XbaseWithAnnotationsTypeProvider
extends XbaseTypeProvider {
    @Inject
    private XAnnotationUtil annotationUtil;

    protected JvmTypeReference expectedType(EObject container, EReference reference, int index, boolean rawType) {
        if (container instanceof XAnnotation) {
            return this._expectedType((XAnnotation)container, reference, index, rawType);
        }
        if (container instanceof XAnnotationElementValueBinaryOperation) {
            return this._expectedType((XAnnotationElementValueBinaryOperation)container, reference, index, rawType);
        }
        if (container instanceof XAnnotationElementValuePair) {
            return this._expectedType((XAnnotationElementValuePair)container, reference, index, rawType);
        }
        if (container instanceof XAnnotationValueArray) {
            return this._expectedType((XAnnotationValueArray)container, reference, index, rawType);
        }
        return super.expectedType(container, reference, index, rawType);
    }

    protected JvmTypeReference _expectedType(XAnnotation annotation, EReference reference, int index, boolean rawType) {
        if (reference == XAnnotationsPackage.Literals.XANNOTATION__VALUE) {
            JvmOperation valueOperation = this.annotationUtil.findSingleValueAttribute(annotation.getAnnotationType());
            if (valueOperation == null) {
                return null;
            }
            return valueOperation.getReturnType();
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XAnnotationElementValuePair annotation, EReference reference, int index, boolean rawType) {
        if (reference == XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_PAIR__VALUE && annotation.getElement() != null) {
            return annotation.getElement().getReturnType();
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XAnnotationElementValueBinaryOperation binaryOp, EReference reference, int index, boolean rawType) {
        if (reference == XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_BINARY_OPERATION__RIGHT_OPERAND) {
            return this.getType(binaryOp.getLeftOperand(), rawType);
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XAnnotationValueArray array, EReference reference, int index, boolean rawType) {
        return this.getExpectedType(array, rawType);
    }

    protected JvmTypeReference type(XExpression expression, JvmTypeReference rawExpectation, boolean rawType) {
        if (expression instanceof XAnnotation) {
            return this._type((XAnnotation)expression, rawExpectation, rawType);
        }
        if (expression instanceof XAnnotationElementValueBinaryOperation) {
            return this._type((XAnnotationElementValueBinaryOperation)expression, rawExpectation, rawType);
        }
        if (expression instanceof XAnnotationValueArray) {
            return this._type((XAnnotationValueArray)expression, rawExpectation, rawType);
        }
        return super.type(expression, rawExpectation, rawType);
    }

    protected JvmTypeReference _type(XAnnotation annotation, JvmTypeReference rawExpectation, boolean rawType) {
        JvmAnnotationType annotationType = annotation.getAnnotationType();
        if (annotationType == null) {
            return null;
        }
        return this.getTypeReferences().createTypeRef((JvmType)annotationType, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XAnnotationElementValueBinaryOperation annotation, JvmTypeReference rawExpectation, boolean rawType) {
        return this.getType(annotation.getLeftOperand(), rawExpectation, rawType);
    }

    protected JvmTypeReference _type(XAnnotationValueArray annotation, JvmTypeReference rawExpectation, boolean rawType) {
        ArrayList references = Lists.newArrayList();
        for (XExpression expression : annotation.getValues()) {
            references.add(this.getType(expression, rawType));
        }
        JvmTypeReference commonType = this.getCommonType(references);
        return this.getTypeReferences().createArrayType(commonType);
    }
}

