/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.blink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.nattable.blink.BlinkConfigAttributes;
import net.sourceforge.nattable.blink.IBlinkingCellResolver;
import net.sourceforge.nattable.blink.UpdateEventsCache;
import net.sourceforge.nattable.blink.command.BlinkTimerEnableCommandHandler;
import net.sourceforge.nattable.blink.event.BlinkEvent;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.IndexCoordinate;
import net.sourceforge.nattable.data.IColumnPropertyResolver;
import net.sourceforge.nattable.data.IRowDataProvider;
import net.sourceforge.nattable.data.IRowIdAccessor;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.layer.event.PropertyUpdateEvent;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlinkLayer<T>
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private final IUniqueIndexLayer dataLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final IConfigRegistry configRegistry;
    private final IRowIdAccessor<T> rowIdAccessor;
    private Timer stopBlinkTimer;
    protected boolean blinkingEnabled = true;
    private final UpdateEventsCache<T> updateEventsCache;
    private int blinkDurationInMilis = 1000;
    Map<String, PropertyUpdateEvent<T>> blinkingUpdates = new HashMap<String, PropertyUpdateEvent<T>>();
    Map<String, TimerTask> blinkingTasks = new HashMap<String, TimerTask>();

    public BlinkLayer(IUniqueIndexLayer dataLayer, IRowDataProvider<T> listDataProvider, IRowIdAccessor<T> rowIdAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry) {
        super(dataLayer);
        this.dataLayer = dataLayer;
        this.rowDataProvider = listDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.configRegistry = configRegistry;
        this.updateEventsCache = new UpdateEventsCache<T>(rowIdAccessor, columnPropertyResolver);
        this.registerCommandHandler(new BlinkTimerEnableCommandHandler(this));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (!this.blinkingEnabled) {
            return this.getUnderlyingLayer().getConfigLabelsByPosition(columnPosition, rowPosition);
        }
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(rowPosition);
        int columnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(columnPosition);
        String rowId = this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex)).toString();
        String key = this.updateEventsCache.getKey(columnIndex, rowId);
        LabelStack underlyingLabelStack = this.getUnderlyingLayer().getConfigLabelsByPosition(columnPosition, rowPosition);
        IndexCoordinate coordinate = new IndexCoordinate(columnIndex, rowIndex);
        if (this.updateEventsCache.isUpdated(key)) {
            LabelStack blinkingConfigTypes;
            PropertyUpdateEvent<T> event = this.updateEventsCache.getEvent(key);
            if (this.blinkingUpdates.containsKey(key)) {
                this.blinkingTasks.get(key).cancel();
                this.getStopBlinkTimer().purge();
                this.blinkingTasks.remove(key);
                this.blinkingUpdates.remove(key);
            }
            if ((blinkingConfigTypes = this.resolveConfigTypes(event.getOldValue(), event.getNewValue(), coordinate, this.getUnderlyingLayer())) != null) {
                TimerTask stopBlinkTask = this.getStopBlinkTask(key, this);
                this.blinkingUpdates.put(key, event);
                this.blinkingTasks.put(key, stopBlinkTask);
                this.updateEventsCache.remove(key);
                this.getStopBlinkTimer().schedule(stopBlinkTask, this.blinkDurationInMilis);
                return blinkingConfigTypes;
            }
            return new LabelStack(new String[0]);
        }
        if (this.blinkingUpdates.containsKey(key)) {
            PropertyUpdateEvent<T> event = this.blinkingUpdates.get(key);
            return this.resolveConfigTypes(event.getOldValue(), event.getNewValue(), coordinate, this.getUnderlyingLayer());
        }
        return underlyingLabelStack;
    }

    private IBlinkingCellResolver getBlinkingCellResolver(List<String> configTypes) {
        return this.configRegistry.getConfigAttribute(BlinkConfigAttributes.BLINK_RESOLVER, "NORMAL", configTypes);
    }

    public LabelStack resolveConfigTypes(Object oldValue, Object newValue, IndexCoordinate coordinate, ILayer underlyingLayer) {
        LabelStack underlyingLabelStack = underlyingLayer.getConfigLabelsByPosition(coordinate.columnIndex, coordinate.rowIndex);
        IBlinkingCellResolver resolver = this.getBlinkingCellResolver(underlyingLabelStack.getLabels());
        String[] blinkConfigTypes = null;
        if (resolver != null) {
            blinkConfigTypes = resolver.resolve(oldValue, newValue);
        }
        if (blinkConfigTypes != null && blinkConfigTypes.length > 0) {
            return new LabelStack(blinkConfigTypes);
        }
        return null;
    }

    private TimerTask getStopBlinkTask(final String key, final ILayer layer) {
        return new TimerTask(){

            public void run() {
                BlinkLayer.this.blinkingUpdates.remove(key);
                BlinkLayer.this.blinkingTasks.remove(key);
                if (BlinkLayer.this.blinkingTasks.isEmpty()) {
                    BlinkLayer.this.stopBlinkTimer.cancel();
                    BlinkLayer.this.stopBlinkTimer = null;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        BlinkLayer.this.fireLayerEvent(new BlinkEvent(layer));
                    }
                });
            }
        };
    }

    public Timer getStopBlinkTimer() {
        if (this.stopBlinkTimer == null) {
            this.stopBlinkTimer = new Timer("Stop Blink Task Timer");
        }
        return this.stopBlinkTimer;
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof PropertyUpdateEvent) {
            this.updateEventsCache.put((PropertyUpdateEvent)event);
        }
        super.handleLayerEvent(event);
    }

    public void setBlinkingEnabled(boolean enabled) {
        this.blinkingEnabled = enabled;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.dataLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.dataLayer.getRowPositionByIndex(rowIndex);
    }

    public void setBlinkDurationInMilis(int blinkDurationInMilis) {
        this.blinkDurationInMilis = blinkDurationInMilis;
    }
}

