/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.layer;

import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.export.excel.command.ExportToExcelCommandHandler;
import net.sourceforge.nattable.grid.command.AutoResizeColumnCommandHandler;
import net.sourceforge.nattable.grid.command.AutoResizeRowCommandHandler;
import net.sourceforge.nattable.grid.layer.config.DefaultGridLayerConfiguration;
import net.sourceforge.nattable.layer.CompositeLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.print.command.PrintCommandHandler;

public class GridLayer
extends CompositeLayer {
    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer) {
        this(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer, true);
    }

    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.setBodyLayer(bodyLayer);
        this.setColumnHeaderLayer(columnHeaderLayer);
        this.setRowHeaderLayer(rowHeaderLayer);
        this.setCornerLayer(cornerLayer);
        this.init(useDefaultConfiguration);
    }

    protected GridLayer(boolean useDefaultConfiguration) {
        super(2, 2);
        this.init(useDefaultConfiguration);
    }

    protected void init(boolean useDefaultConfiguration) {
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultGridLayerConfiguration(this));
        }
    }

    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PrintCommandHandler(this));
        this.registerCommandHandler(new ExportToExcelCommandHandler(this));
        this.registerCommandHandler(new AutoResizeColumnCommandHandler(this));
        this.registerCommandHandler(new AutoResizeRowCommandHandler(this));
    }

    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        if (this.doCommandOnChildLayer(command, this.getBodyLayer())) {
            return true;
        }
        if (this.doCommandOnChildLayer(command, this.getColumnHeaderLayer())) {
            return true;
        }
        if (this.doCommandOnChildLayer(command, this.getRowHeaderLayer())) {
            return true;
        }
        return this.doCommandOnChildLayer(command, this.getCornerLayer());
    }

    private boolean doCommandOnChildLayer(ILayerCommand command, ILayer childLayer) {
        ILayerCommand childCommand = command.cloneCommand();
        return childLayer.doCommand(childCommand);
    }

    public ILayer getCornerLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 0);
    }

    public void setCornerLayer(ILayer cornerLayer) {
        this.setChildLayer("CORNER", cornerLayer, 0, 0);
    }

    public ILayer getColumnHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 0);
    }

    public void setColumnHeaderLayer(ILayer columnHeaderLayer) {
        this.setChildLayer("COLUMN_HEADER", columnHeaderLayer, 1, 0);
    }

    public ILayer getRowHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 1);
    }

    public void setRowHeaderLayer(ILayer rowHeaderLayer) {
        this.setChildLayer("ROW_HEADER", rowHeaderLayer, 0, 1);
    }

    public ILayer getBodyLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 1);
    }

    public void setBodyLayer(ILayer bodyLayer) {
        this.setChildLayer("BODY", bodyLayer, 1, 1);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[corner=" + this.getCornerLayer() + " columnHeader=" + this.getColumnHeaderLayer() + " rowHeader=" + this.getRowHeaderLayer() + " bodyLayer=" + this.getBodyLayer() + "]";
    }
}

