/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.persistence;

import java.util.Properties;
import net.sourceforge.nattable.persistence.ColorPersistor;
import net.sourceforge.nattable.style.BorderStyle;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.Style;
import net.sourceforge.nattable.style.VerticalAlignmentEnum;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class StylePersistor {
    public static final String STYLE_PERSISTENCE_PREFIX = "style";
    public static final String BLUE_COLOR_PREFIX = "blue";
    public static final String GREEN_COLOR_PREFIX = "green";
    public static final String RED_COLOR_PREFIX = "red";
    public static final String V_ALIGNMENT_PREFIX = "verticalAlignment";
    public static final String H_ALIGNMENT_PREFIX = "horizontalAlignment";
    public static final String BG_COLOR_PREFIX = "bg";
    public static final String FG_COLOR_PREFIX = "fg";
    public static final String FONT_PREFIX = "font";
    public static final String BORDER_PREFIX = "border";

    public static void saveStyle(String prefix, Properties properties, Style style) {
        prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX;
        StylePersistor.saveColor(String.valueOf(prefix) + "." + BG_COLOR_PREFIX, properties, style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        StylePersistor.saveColor(String.valueOf(prefix) + "." + FG_COLOR_PREFIX, properties, style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        StylePersistor.saveHAlign(prefix, properties, style.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT));
        StylePersistor.saveVAlign(prefix, properties, style.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT));
        StylePersistor.saveFont(prefix, properties, style.getAttributeValue(CellStyleAttributes.FONT));
        StylePersistor.saveBorder(prefix, properties, style.getAttributeValue(CellStyleAttributes.BORDER_STYLE));
    }

    protected static void saveVAlign(String prefix, Properties properties, VerticalAlignmentEnum vAlign) {
        if (vAlign == null) {
            return;
        }
        properties.setProperty(String.valueOf(prefix) + "." + V_ALIGNMENT_PREFIX, vAlign.name());
    }

    protected static void saveHAlign(String prefix, Properties properties, HorizontalAlignmentEnum hAlign) {
        if (hAlign == null) {
            return;
        }
        properties.setProperty(String.valueOf(prefix) + "." + H_ALIGNMENT_PREFIX, hAlign.name());
    }

    protected static void saveBorder(String prefix, Properties properties, BorderStyle borderStyle) {
        if (borderStyle == null) {
            return;
        }
        properties.setProperty(String.valueOf(prefix) + "." + BORDER_PREFIX, String.valueOf(borderStyle.toString()));
    }

    protected static void saveFont(String prefix, Properties properties, Font font) {
        if (font == null) {
            return;
        }
        properties.setProperty(String.valueOf(prefix) + "." + FONT_PREFIX, String.valueOf(font.getFontData()[0].toString()));
    }

    protected static void saveColor(String prefix, Properties properties, Color color) {
        if (color == null) {
            return;
        }
        ColorPersistor.saveColor(prefix, properties, color);
    }

    public static Style loadStyle(String prefix, Properties properties) {
        String borderPrefix;
        BorderStyle borderStyle;
        String fontPrefix;
        Font font;
        String vAlignPrefix;
        VerticalAlignmentEnum vAlign;
        String hAlignPrefix;
        HorizontalAlignmentEnum hAlign;
        String fgColorPrefix;
        Color fgColor;
        Style style = new Style();
        String bgColorPrefix = String.valueOf(prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX) + "." + BG_COLOR_PREFIX;
        Color bgColor = StylePersistor.loadColor(bgColorPrefix, properties);
        if (bgColor != null) {
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, bgColor);
        }
        if ((fgColor = StylePersistor.loadColor(fgColorPrefix = String.valueOf(prefix) + "." + FG_COLOR_PREFIX, properties)) != null) {
            style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, fgColor);
        }
        if ((hAlign = StylePersistor.loadHAlignment(hAlignPrefix = String.valueOf(prefix) + "." + H_ALIGNMENT_PREFIX, properties)) != null) {
            style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, hAlign);
        }
        if ((vAlign = StylePersistor.loadVAlignment(vAlignPrefix = String.valueOf(prefix) + "." + V_ALIGNMENT_PREFIX, properties)) != null) {
            style.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, vAlign);
        }
        if ((font = StylePersistor.loadFont(fontPrefix = String.valueOf(prefix) + "." + FONT_PREFIX, properties)) != null) {
            style.setAttributeValue(CellStyleAttributes.FONT, font);
        }
        if ((borderStyle = StylePersistor.loadBorderStyle(borderPrefix = String.valueOf(prefix) + "." + BORDER_PREFIX, properties)) != null) {
            style.setAttributeValue(CellStyleAttributes.BORDER_STYLE, borderStyle);
        }
        return style;
    }

    private static BorderStyle loadBorderStyle(String borderPrefix, Properties properties) {
        String borderStyle = properties.getProperty(borderPrefix);
        if (borderStyle != null) {
            return new BorderStyle(borderStyle);
        }
        return null;
    }

    private static Font loadFont(String fontPrefix, Properties properties) {
        String fontdata = properties.getProperty(fontPrefix);
        if (fontdata != null) {
            return GUIHelper.getFont(new FontData(fontdata));
        }
        return null;
    }

    private static HorizontalAlignmentEnum loadHAlignment(String hAlignPrefix, Properties properties) {
        String enumName = properties.getProperty(hAlignPrefix);
        if (enumName != null) {
            return HorizontalAlignmentEnum.valueOf(enumName);
        }
        return null;
    }

    private static VerticalAlignmentEnum loadVAlignment(String vAlignPrefix, Properties properties) {
        String enumName = properties.getProperty(vAlignPrefix);
        if (enumName != null) {
            return VerticalAlignmentEnum.valueOf(enumName);
        }
        return null;
    }

    protected static Color loadColor(String prefix, Properties properties) {
        return ColorPersistor.loadColor(prefix, properties);
    }
}

