/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.selection.MoveCellSelectionCommandHandler;
import net.sourceforge.nattable.selection.SelectionLayer;

public class MoveRowSelectionCommandHandler
extends MoveCellSelectionCommandHandler {
    public MoveRowSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    protected void moveLastSelectedLeft(int stepSize, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedLeft(stepSize, withShiftMask, withControlMask);
        this.selectionLayer.selectRow(this.newSelectedColumnPosition, this.lastSelectedCell.rowPosition, withShiftMask, withControlMask);
    }

    protected void moveLastSelectedRight(int stepSize, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedRight(stepSize, withShiftMask, withControlMask);
        this.selectionLayer.selectRow(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, withShiftMask, withControlMask);
    }

    protected void moveLastSelectedUp(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            int newSelectedRowPosition;
            PositionCoordinate lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.rowPosition - stepSize : 0;
            if (newSelectedRowPosition < 0) {
                newSelectedRowPosition = 0;
            }
            this.selectionLayer.selectRow(lastSelectedCell.columnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
        }
    }

    protected void moveLastSelectedDown(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            int newSelectedRowPosition;
            PositionCoordinate lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.rowPosition + stepSize : this.selectionLayer.getRowCount() - 1;
            if (newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
            }
            this.selectionLayer.selectRow(lastSelectedCell.columnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
        }
    }
}

