/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.SelectionUtils;
import net.sourceforge.nattable.selection.command.SelectRowsCommand;
import net.sourceforge.nattable.selection.event.RowSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRowCommandHandler
implements ILayerCommandHandler<SelectRowsCommand> {
    private final SelectionLayer selectionLayer;

    public SelectRowCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectRowsCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectRows(command.getColumnPosition(), command.getRowPositions(), command.isWithShiftMask(), command.isWithControlMask());
            return true;
        }
        return false;
    }

    protected void selectRows(int columnPosition, Collection<Integer> rowPositions, boolean withShiftMask, boolean withControlMask) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        for (int rowPosition : rowPositions) {
            changedRowRanges.addAll(this.internalSelectRow(columnPosition, rowPosition, withShiftMask, withControlMask));
        }
        HashSet<Integer> changedRows = new HashSet<Integer>();
        for (Range range : changedRowRanges) {
            int i = range.start;
            while (i < range.end) {
                changedRows.add(i);
                ++i;
            }
        }
        this.selectionLayer.fireLayerEvent(new RowSelectionEvent(this.selectionLayer, changedRows));
    }

    private Set<Range> internalSelectRow(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            changedRowRanges.addAll(this.selectionLayer.getSelectedRows());
            this.selectionLayer.clear();
            this.selectionLayer.selectCell(0, rowPosition, withShiftMask, withControlMask);
            this.selectionLayer.selectRegion(0, rowPosition, this.selectionLayer.getColumnCount(), 1);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
            changedRowRanges.add(new Range(rowPosition, rowPosition + 1));
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithShiftKey(rowPosition));
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithShiftKey(rowPosition));
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithCtrlKey(columnPosition, rowPosition));
        }
        this.selectionLayer.lastSelectedCell.columnPosition = this.selectionLayer.getColumnCount() - 1;
        this.selectionLayer.lastSelectedCell.rowPosition = rowPosition;
        return changedRowRanges;
    }

    private Range selectRowWithCtrlKey(int columnPosition, int rowPosition) {
        Rectangle selectedRowRectangle = new Rectangle(0, rowPosition, this.selectionLayer.getColumnCount(), 1);
        if (this.selectionLayer.isRowFullySelected(rowPosition)) {
            this.selectionLayer.clearSelection(selectedRowRectangle);
            if (this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.lastSelectedRegion.equals((Object)selectedRowRectangle)) {
                this.selectionLayer.lastSelectedRegion = null;
            }
        } else {
            if (this.selectionLayer.lastSelectedRegion != null) {
                this.selectionLayer.selectionModel.addSelection(new Rectangle(this.selectionLayer.lastSelectedRegion.x, this.selectionLayer.lastSelectedRegion.y, this.selectionLayer.lastSelectedRegion.width, this.selectionLayer.lastSelectedRegion.height));
            }
            this.selectionLayer.selectRegion(0, rowPosition, this.selectionLayer.getColumnCount(), 1);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
        return new Range(rowPosition, rowPosition + 1);
    }

    private Range selectRowWithShiftKey(int rowPosition) {
        int numOfRowsToIncludeInRegion = 1;
        int startRowPosition = rowPosition;
        if (this.selectionLayer.lastSelectedRegion != null) {
            numOfRowsToIncludeInRegion = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - rowPosition) + 1;
            startRowPosition = startRowPosition < this.selectionLayer.selectionAnchor.rowPosition ? rowPosition : this.selectionLayer.selectionAnchor.rowPosition;
        }
        this.selectionLayer.selectRegion(0, startRowPosition, this.selectionLayer.getColumnCount(), numOfRowsToIncludeInRegion);
        return new Range(startRowPosition, startRowPosition + numOfRowsToIncludeInRegion);
    }

    @Override
    public Class<SelectRowsCommand> getCommandClass() {
        return SelectRowsCommand.class;
    }
}

