/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.copy.command.CopyDataCommandHandler;
import net.sourceforge.nattable.edit.command.EditSelectionCommandHandler;
import net.sourceforge.nattable.grid.command.InitializeAutoResizeColumnsCommandHandler;
import net.sourceforge.nattable.grid.command.InitializeAutoResizeRowsCommandHandler;
import net.sourceforge.nattable.hideshow.command.ColumnHideCommand;
import net.sourceforge.nattable.hideshow.command.MultiColumnHideCommand;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.painter.layer.ILayerPainter;
import net.sourceforge.nattable.resize.command.ColumnResizeCommand;
import net.sourceforge.nattable.resize.command.MultiColumnResizeCommand;
import net.sourceforge.nattable.resize.command.MultiRowResizeCommand;
import net.sourceforge.nattable.resize.command.RowResizeCommand;
import net.sourceforge.nattable.search.command.SearchGridCellsCommandHandler;
import net.sourceforge.nattable.selection.ISelectionModel;
import net.sourceforge.nattable.selection.SelectCellCommandHandler;
import net.sourceforge.nattable.selection.SelectColumnCommandHandler;
import net.sourceforge.nattable.selection.SelectRowCommandHandler;
import net.sourceforge.nattable.selection.SelectionLayerPainter;
import net.sourceforge.nattable.selection.SelectionModel;
import net.sourceforge.nattable.selection.command.ClearAllSelectionsCommand;
import net.sourceforge.nattable.selection.command.SelectAllCommand;
import net.sourceforge.nattable.selection.config.DefaultSelectionLayerConfiguration;
import net.sourceforge.nattable.selection.event.CellSelectionEvent;
import net.sourceforge.nattable.selection.event.SelectionLayerStructuralChangeEventHandler;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    public static final int MOVE_ALL = -1;
    private static final int NO_SELECTION = -1;
    protected ISelectionModel selectionModel;
    protected IUniqueIndexLayer underlyingLayer;
    protected final PositionCoordinate lastSelectedCell;
    protected final PositionCoordinate selectionAnchor;
    protected Rectangle lastSelectedRegion;
    private final SelectRowCommandHandler selectRowCommandHandler;
    private final SelectCellCommandHandler selectCellCommandHandler;
    private final SelectColumnCommandHandler selectColumnCommandHandler;

    public SelectionLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, new SelectionModel(), true);
    }

    public SelectionLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        this(underlyingLayer, new SelectionModel(), useDefaultConfiguration);
    }

    public SelectionLayer(IUniqueIndexLayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.setLayerPainter(new SelectionLayerPainter());
        this.selectionModel = selectionModel;
        this.lastSelectedCell = new PositionCoordinate(this, -1, -1);
        this.selectionAnchor = new PositionCoordinate(this, -1, -1);
        this.selectRowCommandHandler = new SelectRowCommandHandler(this);
        this.selectCellCommandHandler = new SelectCellCommandHandler(this);
        this.selectColumnCommandHandler = new SelectColumnCommandHandler(this);
        this.registerCommandHandlers();
        this.registerEventHandler(new SelectionLayerStructuralChangeEventHandler(this, selectionModel));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSelectionLayerConfiguration());
        }
    }

    public void setSelectionModel(ISelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    public boolean hasColumnSelection() {
        return this.lastSelectedCell.columnPosition != -1;
    }

    public boolean isColumnPositionSelected(int columnPosition) {
        return this.selectionModel.isColumnPositionSelected(columnPosition);
    }

    public int[] getSelectedColumns() {
        return this.selectionModel.getSelectedColumns();
    }

    public int[] getFullySelectedColumnPositions() {
        return this.selectionModel.getFullySelectedColumns(this.getRowCount());
    }

    public int[] getFullySelectedColumns() {
        return this.selectionModel.getFullySelectedColumns(this.getRowCount());
    }

    public boolean isColumnFullySelected(int columnPosition) {
        return this.selectionModel.isColumnFullySelected(columnPosition, this.getRowCount());
    }

    public void selectColumn(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectColumnCommandHandler.selectColumn(columnPosition, rowPosition, withShiftMask, withControlMask);
    }

    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        return this.selectionModel.isCellPositionSelected(columnPosition, rowPosition);
    }

    public void setSelectedCell(int columnPosition, int rowPosition) {
        this.selectCell(columnPosition, rowPosition, false, false);
    }

    protected PositionCoordinate getCellPositionToMoveFrom(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && !withControlMask ? this.getSelectionAnchor() : this.getLastSelectedCellPosition();
    }

    public PositionCoordinate[] getSelectedCells() {
        int[] selectedColumnPositions = this.getSelectedColumns();
        Set<Range> selectedRowPositions = this.getSelectedRows();
        LinkedList<PositionCoordinate> selectedCells = new LinkedList<PositionCoordinate>();
        int columnPositionIndex = 0;
        while (columnPositionIndex < selectedColumnPositions.length) {
            int columnPosition = selectedColumnPositions[columnPositionIndex];
            for (Range rowIndexRange : selectedRowPositions) {
                int rowPositionIndex = rowIndexRange.start;
                while (rowPositionIndex < rowIndexRange.end) {
                    if (this.selectionModel.isCellPositionSelected(columnPosition, rowPositionIndex)) {
                        selectedCells.add(new PositionCoordinate(this, columnPosition, rowPositionIndex));
                    }
                    ++rowPositionIndex;
                }
            }
            ++columnPositionIndex;
        }
        return selectedCells.toArray(new PositionCoordinate[0]);
    }

    public void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectCellCommandHandler.selectCell(columnPosition, rowPosition, withShiftMask, withControlMask);
    }

    public PositionCoordinate getSelectionAnchor() {
        return this.selectionAnchor;
    }

    public PositionCoordinate getLastSelectedCellPosition() {
        if (this.lastSelectedCell.columnPosition != -1 && this.lastSelectedCell.rowPosition != -1) {
            return this.lastSelectedCell;
        }
        return null;
    }

    protected void setLastSelectedCell(int columnPosition, int rowPosition) {
        this.lastSelectedCell.columnPosition = columnPosition;
        this.lastSelectedCell.rowPosition = rowPosition;
    }

    public boolean hasRowSelection() {
        return this.lastSelectedCell.rowPosition != -1;
    }

    public boolean isRowPositionSelected(int rowPosition) {
        return this.selectionModel.isRowPositionSelected(rowPosition);
    }

    public boolean isRowFullySelected(int rowPosition) {
        return this.selectionModel.isRowFullySelected(rowPosition, this.getColumnCount());
    }

    public Set<Range> getSelectedRows() {
        return this.selectionModel.getSelectedRows();
    }

    public int[] getFullySelectedRowPositions() {
        return this.selectionModel.getFullySelectedRows(this.getColumnCount());
    }

    protected ISelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getSelectedRowCount() {
        return this.selectionModel.getSelectedRowCount();
    }

    public void selectRow(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectRowCommandHandler.selectRows(columnPosition, Arrays.asList(rowPosition), withShiftMask, withControlMask);
    }

    public void clear() {
        this.selectionModel.clearSelection();
        this.lastSelectedCell.columnPosition = -1;
        this.lastSelectedCell.rowPosition = -1;
        this.lastSelectedRegion = new Rectangle(0, 0, 0, 0);
        this.selectionAnchor.columnPosition = -1;
        this.selectionAnchor.rowPosition = -1;
    }

    protected void clearSelection(int columnPosition, int rowPosition) {
        this.selectionModel.removeSelection(columnPosition, rowPosition);
    }

    protected void clearSelection(Rectangle selection) {
        this.selectionModel.removeSelection(selection);
    }

    protected void addSelection(Rectangle selection) {
        if (selection != this.lastSelectedRegion) {
            this.selectionAnchor.columnPosition = this.lastSelectedCell.columnPosition;
            this.selectionAnchor.rowPosition = this.lastSelectedCell.rowPosition;
            this.lastSelectedRegion = selection;
        }
        this.selectionModel.addSelection(selection);
    }

    public void selectAll() {
        Rectangle selection = new Rectangle(0, 0, this.getColumnCount(), this.getRowCount());
        this.addSelection(selection);
        this.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false, false, false);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (this.isCellPositionSelected(columnPosition, rowPosition)) {
            return "SELECT";
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.selectionAnchor.columnPosition == columnPosition && this.selectionAnchor.rowPosition == rowPosition) {
            labelStack.addLabel("selectionAnchor");
        }
        return labelStack;
    }

    private void registerCommandHandlers() {
        this.registerCommandHandler(this.selectCellCommandHandler);
        this.registerCommandHandler(this.selectRowCommandHandler);
        this.registerCommandHandler(this.selectColumnCommandHandler);
        this.registerCommandHandler(new EditSelectionCommandHandler(this));
        this.registerCommandHandler(new InitializeAutoResizeColumnsCommandHandler(this));
        this.registerCommandHandler(new InitializeAutoResizeRowsCommandHandler(this));
        this.registerCommandHandler(new CopyDataCommandHandler(this));
        this.registerCommandHandler(new SearchGridCellsCommandHandler(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof SelectAllCommand && command.convertToTargetLayer(this)) {
            this.selectAll();
            return true;
        }
        if (command instanceof ClearAllSelectionsCommand && command.convertToTargetLayer(this)) {
            this.clear();
            return true;
        }
        if (command instanceof MultiColumnHideCommand && command.convertToTargetLayer(this)) {
            return this.hideMultipleColumnPositions((MultiColumnHideCommand)command);
        }
        if (command instanceof ColumnHideCommand && command.convertToTargetLayer(this)) {
            return this.hideColumnPosition((ColumnHideCommand)command);
        }
        if (command instanceof ColumnResizeCommand && command.convertToTargetLayer(this)) {
            return this.handleColumnResizeCommand((ColumnResizeCommand)command);
        }
        if (command instanceof RowResizeCommand && command.convertToTargetLayer(this)) {
            return this.handleRowResizeCommand((RowResizeCommand)command);
        }
        return super.doCommand(command);
    }

    protected boolean hideMultipleColumnPositions(MultiColumnHideCommand command) {
        for (int columnPosition : command.getColumnPositions()) {
            if (!this.isColumnFullySelected(columnPosition)) continue;
            Rectangle selection = new Rectangle(columnPosition, 0, 1, this.getRowCount());
            this.clearSelection(selection);
        }
        return super.doCommand(command);
    }

    protected boolean hideColumnPosition(ColumnHideCommand command) {
        if (this.isColumnFullySelected(command.getColumnPosition())) {
            return super.doCommand(new MultiColumnHideCommand((ILayer)this, this.getFullySelectedColumnPositions()));
        }
        return super.doCommand(command);
    }

    protected boolean handleColumnResizeCommand(ColumnResizeCommand command) {
        if (this.isColumnFullySelected(command.getColumnPosition())) {
            return super.doCommand(new MultiColumnResizeCommand((ILayer)this, this.selectionModel.getFullySelectedColumns(this.getRowCount()), command.getNewColumnWidth()));
        }
        return super.doCommand(command);
    }

    protected boolean handleRowResizeCommand(RowResizeCommand command) {
        if (this.isRowFullySelected(command.getRowPosition())) {
            return super.doCommand(new MultiRowResizeCommand((ILayer)this, this.selectionModel.getFullySelectedRows(this.getColumnCount()), command.getNewHeight()));
        }
        return super.doCommand(command);
    }

    protected void selectRegion(int startColumnPosition, int startRowPosition, int regionWidth, int regionHeight) {
        if (this.lastSelectedRegion == null) {
            this.lastSelectedRegion = new Rectangle(startColumnPosition, startRowPosition, regionWidth, regionHeight);
        } else {
            this.lastSelectedRegion.x = startColumnPosition;
            this.lastSelectedRegion.y = startRowPosition;
            this.lastSelectedRegion.width = regionWidth;
            this.lastSelectedRegion.height = regionHeight;
        }
        this.selectionModel.addSelection(this.lastSelectedRegion);
    }

    public void moveSelectionAnchor(int startColumnPositionInRegion, int startRowPosition) {
        this.selectionAnchor.columnPosition = startColumnPositionInRegion;
        this.selectionAnchor.rowPosition = startRowPosition;
    }

    public void fireCellSelectionEvent(int columnPosition, int rowPosition, boolean forcingEntireCellIntoViewport, boolean withShiftMask, boolean withControlMask) {
        CellSelectionEvent selectionEvent = new CellSelectionEvent(this, columnPosition, rowPosition, forcingEntireCellIntoViewport, withShiftMask, withControlMask);
        this.fireLayerEvent(selectionEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveDirectionEnum {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

