/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor;

import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.Style;
import net.sourceforge.nattable.style.VerticalAlignmentEnum;
import net.sourceforge.nattable.style.editor.AbstractEditorPanel;
import net.sourceforge.nattable.style.editor.ColorPicker;
import net.sourceforge.nattable.style.editor.FontPicker;
import net.sourceforge.nattable.style.editor.HorizontalAlignmentPicker;
import net.sourceforge.nattable.style.editor.VerticalAlignmentPicker;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellStyleEditorPanel
extends AbstractEditorPanel<Style> {
    private static final Color DEFAULT_FG_COLOR = GUIHelper.COLOR_BLACK;
    private static final Color DEFAULT_BG_COLOR = GUIHelper.COLOR_WHITE;
    private ColorPicker backgroundColorPicker;
    private ColorPicker foregroundColorPicker;
    private FontPicker fontPicker;
    private HorizontalAlignmentPicker horizontalAlignmentPicker;
    private VerticalAlignmentPicker verticalAlignmentPicker;

    public CellStyleEditorPanel(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        this.setLayout((Layout)gridLayout);
        new Label((Composite)this, 0).setText("Background Color");
        this.backgroundColorPicker = new ColorPicker(this, DEFAULT_BG_COLOR);
        new Label((Composite)this, 0).setText("Foreground Color");
        this.foregroundColorPicker = new ColorPicker(this, DEFAULT_FG_COLOR);
        new Label((Composite)this, 0).setText("Font");
        this.fontPicker = new FontPicker(this, GUIHelper.DEFAULT_FONT);
        this.fontPicker.setLayoutData(new GridData(80, 20));
        new Label((Composite)this, 0).setText("Horizonatal Alignment");
        this.horizontalAlignmentPicker = new HorizontalAlignmentPicker(this, HorizontalAlignmentEnum.CENTER);
        new Label((Composite)this, 0).setText("Vertical Alignment");
        this.verticalAlignmentPicker = new VerticalAlignmentPicker(this, VerticalAlignmentEnum.MIDDLE);
    }

    @Override
    public String getEditorName() {
        return "Basic Style";
    }

    @Override
    public void edit(Style style) throws Exception {
        Color bgColor = style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        this.backgroundColorPicker.setSelectedColor(bgColor != null ? bgColor : GUIHelper.COLOR_WHITE);
        Color fgColor = style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        this.foregroundColorPicker.setSelectedColor(fgColor != null ? fgColor : GUIHelper.COLOR_BLACK);
        this.fontPicker.setFont(style.getAttributeValue(CellStyleAttributes.FONT));
        HorizontalAlignmentEnum hAlign = style.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.horizontalAlignmentPicker.setSelectedAlignment(hAlign != null ? hAlign : HorizontalAlignmentEnum.CENTER);
        VerticalAlignmentEnum vAlign = style.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        this.verticalAlignmentPicker.setSelectedAlignment(vAlign != null ? vAlign : VerticalAlignmentEnum.MIDDLE);
    }

    @Override
    public Style getNewValue() {
        Style newStyle = new Style();
        newStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.backgroundColorPicker.getSelectedColor());
        newStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.foregroundColorPicker.getSelectedColor());
        newStyle.setAttributeValue(CellStyleAttributes.FONT, this.fontPicker.getSelectedFont());
        newStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.horizontalAlignmentPicker.getSelectedAlignment());
        newStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.verticalAlignmentPicker.getSelectedAlignment());
        return newStyle;
    }
}

