/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.RandomAccessByteList;

public class ArrayByteList
extends RandomAccessByteList
implements ByteList,
Serializable {
    private transient byte[] _data = null;
    private int _size = 0;

    public ArrayByteList() {
        this(8);
    }

    public ArrayByteList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new byte[initialCapacity];
        this._size = 0;
    }

    public ArrayByteList(ByteCollection that) {
        this(that.size());
        this.addAll(that);
    }

    public byte get(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public int size() {
        return this._size;
    }

    public byte removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        byte oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public byte set(int index, byte element) {
        this.checkRange(index);
        this.incrModCount();
        byte oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public void add(int index, byte element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            byte[] olddata = this._data;
            this._data = new byte[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            byte[] olddata = this._data;
            this._data = new byte[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeByte(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new byte[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readByte();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

