/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;

public final class ValueRecordsAggregate {
    private int firstcell = -1;
    private int lastcell = -1;
    private CellValueRecordInterface[][] records = new CellValueRecordInterface[30][];

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface[] rowCells;
        int newSize;
        short column = cell.getColumn();
        int row = cell.getRow();
        if (row >= this.records.length) {
            CellValueRecordInterface[][] oldRecords = this.records;
            newSize = oldRecords.length * 2;
            if (newSize < row + 1) {
                newSize = row + 1;
            }
            this.records = new CellValueRecordInterface[newSize][];
            System.arraycopy(oldRecords, 0, this.records, 0, oldRecords.length);
        }
        if ((rowCells = this.records[row]) == null) {
            newSize = column + 1;
            if (newSize < 10) {
                newSize = 10;
            }
            rowCells = new CellValueRecordInterface[newSize];
            this.records[row] = rowCells;
        }
        if (column >= rowCells.length) {
            CellValueRecordInterface[] oldRowCells = rowCells;
            int newSize2 = oldRowCells.length * 2;
            if (newSize2 < column + 1) {
                newSize2 = column + 1;
            }
            rowCells = new CellValueRecordInterface[newSize2];
            System.arraycopy(oldRowCells, 0, rowCells, 0, oldRowCells.length);
            this.records[row] = rowCells;
        }
        rowCells[column] = cell;
        if (column < this.firstcell || this.firstcell == -1) {
            this.firstcell = column;
        }
        if (column > this.lastcell || this.lastcell == -1) {
            this.lastcell = column;
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        int row = cell.getRow();
        if (row >= this.records.length) {
            throw new RuntimeException("cell row is out of range");
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            throw new RuntimeException("cell row is already empty");
        }
        short column = cell.getColumn();
        if (column >= rowCells.length) {
            throw new RuntimeException("cell column is out of range");
        }
        rowCells[column] = null;
    }

    public void removeAllCellsValuesForRow(int rowIndex) {
        if (rowIndex >= this.records.length) {
            throw new IllegalArgumentException("Specified rowIndex " + rowIndex + " is outside the allowable range (0.." + this.records.length + ")");
        }
        this.records[rowIndex] = null;
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        int r = 0;
        while (r < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[r];
            if (rowCells != null) {
                int c = 0;
                while (c < rowCells.length) {
                    if (rowCells[c] != null) {
                        ++count;
                    }
                    c = (short)(c + 1);
                }
            }
            ++r;
        }
        return count;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public void construct(CellValueRecordInterface rec, RecordStream rs, SharedValueManager sfh) {
        if (rec instanceof FormulaRecord) {
            Class nextClass;
            FormulaRecord formulaRec = (FormulaRecord)rec;
            if (formulaRec.isSharedFormula()) {
                sfh.convertSharedFormulaRecord(formulaRec);
            }
            StringRecord cachedText = (nextClass = rs.peekNextClass()) == StringRecord.class ? (StringRecord)rs.getNext() : null;
            this.insertCell(new FormulaRecordAggregate(formulaRec, cachedText, sfh));
        } else {
            this.insertCell(rec);
        }
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        MyIterator itr = new MyIterator(startRow, endRow);
        int size = 0;
        while (itr.hasNext()) {
            CellValueRecordInterface cell = (CellValueRecordInterface)itr.next();
            int row = cell.getRow();
            if (row > endRow) break;
            if (row < startRow || row > endRow) continue;
            size += ((RecordBase)((Object)cell)).getRecordSize();
        }
        return size;
    }

    public boolean rowHasCells(int row) {
        if (row > this.records.length - 1) {
            return false;
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            return false;
        }
        int col = 0;
        while (col < rowCells.length) {
            if (rowCells[col] != null) {
                return true;
            }
            ++col;
        }
        return false;
    }

    public int serializeCellRow(int row, int offset, byte[] data) {
        MyIterator itr = new MyIterator(row, row);
        int pos = offset;
        while (itr.hasNext()) {
            CellValueRecordInterface cell = (CellValueRecordInterface)itr.next();
            if (cell.getRow() != row) break;
            pos += ((RecordBase)((Object)cell)).serialize(pos, data);
        }
        return pos - offset;
    }

    public void visitCellsForRow(int rowIndex, RecordAggregate.RecordVisitor rv) {
        CellValueRecordInterface[] cellRecs = this.records[rowIndex];
        if (cellRecs != null) {
            int i = 0;
            while (i < cellRecs.length) {
                CellValueRecordInterface cvr = cellRecs[i];
                if (cvr != null) {
                    if (cvr instanceof RecordAggregate) {
                        RecordAggregate agg = (RecordAggregate)((Object)cvr);
                        agg.visitContainedRecords(rv);
                    } else {
                        Record rec = (Record)((Object)cvr);
                        rv.visitRecord(rec);
                    }
                }
                ++i;
            }
        }
    }

    public void updateFormulasAfterRowShift(FormulaShifter shifter, int currentExternSheetIndex) {
        int i = 0;
        while (i < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[i];
            if (rowCells != null) {
                int j = 0;
                while (j < rowCells.length) {
                    FormulaRecord fr;
                    Ptg[] ptgs;
                    CellValueRecordInterface cell = rowCells[j];
                    if (cell instanceof FormulaRecordAggregate && shifter.adjustFormula(ptgs = (fr = ((FormulaRecordAggregate)cell).getFormulaRecord()).getParsedExpression(), currentExternSheetIndex)) {
                        fr.setParsedExpression(ptgs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public CellValueRecordInterface[] getValueRecords() {
        ArrayList<CellValueRecordInterface> temp = new ArrayList<CellValueRecordInterface>();
        int i = 0;
        while (i < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[i];
            if (rowCells != null) {
                int j = 0;
                while (j < rowCells.length) {
                    CellValueRecordInterface cell = rowCells[j];
                    if (cell != null) {
                        temp.add(cell);
                    }
                    ++j;
                }
            }
            ++i;
        }
        CellValueRecordInterface[] result = new CellValueRecordInterface[temp.size()];
        temp.toArray(result);
        return result;
    }

    public Iterator getIterator() {
        return new MyIterator();
    }

    private final class MyIterator
    implements Iterator {
        short nextColumn = (short)-1;
        int nextRow;
        int lastRow;

        public MyIterator() {
            this.nextRow = 0;
            this.lastRow = ValueRecordsAggregate.this.records.length - 1;
            this.findNext();
        }

        public MyIterator(int firstRow, int lastRow) {
            this.nextRow = firstRow;
            this.lastRow = lastRow;
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextRow <= this.lastRow;
        }

        public Object next() {
            CellValueRecordInterface o = ValueRecordsAggregate.this.records[this.nextRow][this.nextColumn];
            this.findNext();
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException("gibt's noch nicht");
        }

        /*
         * Unable to fully structure code
         */
        private void findNext() {
            this.nextColumn = (short)(this.nextColumn + 1);
            while (this.nextRow <= this.lastRow) {
                block3: {
                    v0 = rowCells = this.nextRow < ValueRecordsAggregate.access$0(ValueRecordsAggregate.this).length ? ValueRecordsAggregate.access$0(ValueRecordsAggregate.this)[this.nextRow] : null;
                    if (rowCells != null) ** GOTO lbl10
                    this.nextColumn = 0;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        if (rowCells[this.nextColumn] != null) {
                            return;
                        }
                        this.nextColumn = (short)(this.nextColumn + 1);
lbl10:
                        // 2 sources

                        ** while (this.nextColumn < rowCells.length)
                    }
lbl11:
                    // 1 sources

                    this.nextColumn = 0;
                }
                ++this.nextRow;
            }
        }
    }
}

