/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemFigureProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ChartReportItemUIImpl
extends ReportItemFigureProvider {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static Map<DesignElementHandle, Listener> listenerMap = new HashMap<DesignElementHandle, Listener>();

    public final IFigure createFigure(final ExtendedItemHandle eih) {
        try {
            eih.loadExtendedElement();
        }
        catch (ExtendedElementException eeex) {
            logger.log((Exception)((Object)eeex));
        }
        try {
            DesignElementHandle hostChart;
            ChartReportItemImpl iri = (ChartReportItemImpl)eih.getReportItem();
            DesignerRepresentation dr = ChartReportItemUIFactory.instance().createFigure(iri);
            this.refreshBackgroundImage((DesignElementHandle)eih, dr);
            iri.setDesignerRepresentation((Object)dr);
            if (iri.isCopied() && ChartCubeUtil.isPlotChart((DesignElementHandle)eih)) {
                ExtendedItemHandle axisChart;
                AggregationCellHandle containerCell;
                AggregationCellHandle grandTotalCell;
                Object content;
                ChartWithAxes cwa = (ChartWithAxes)iri.getProperty("chart.instance");
                Axis yAxis = (Axis)((Axis)cwa.getAxes().get(0)).getAssociatedAxes().get(0);
                if (yAxis.getLineAttributes().isVisible() && ChartCubeUtil.findReferenceChart((ExtendedItemHandle)eih) == null && ChartCubeUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)(content = ChartCubeUtil.getFirstContent((CrosstabCellHandle)(grandTotalCell = ChartXTabUIUtil.getGrandTotalAggregationCell((AggregationCellHandle)(containerCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)eih)), (boolean)cwa.isTransposed())))))) && !(axisChart = (ExtendedItemHandle)content).getElementProperty("hostChart").equals(eih)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                axisChart.setProperty("hostChart", (Object)eih);
                            }
                            catch (SemanticException e) {
                                logger.log((Exception)((Object)e));
                            }
                        }
                    });
                }
            } else if (ChartCubeUtil.isAxisChart((DesignElementHandle)eih) && (hostChart = eih.getElementProperty("hostChart")) != null) {
                Listener listener = this.createDeleteChartListener((DesignElementHandle)eih);
                DesignElementHandle cell = hostChart.getContainer();
                cell.addListener(listener);
                if (cell.getContainer() != null) {
                    cell.getContainer().addListener(listener);
                }
            }
            return dr;
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
            return null;
        }
    }

    public final void updateFigure(ExtendedItemHandle eih, IFigure ifg) {
        try {
            eih.loadExtendedElement();
            eih.getReportItem().setHandle(eih);
            this.refreshBackgroundImage((DesignElementHandle)eih, (ReportElementFigure)ifg);
            IDisplayServer idsSWT = ChartUIUtil.getDisplayServer();
            int dpi = idsSWT.getDpiResolution();
            Bounds bounds = ChartItemUtil.computeChartBounds((ExtendedItemHandle)eih, (int)dpi);
            if (bounds == null) {
                return;
            }
            double dHeightInPixels = (double)dpi * bounds.getHeight() / 72.0;
            double dWidthInPixels = (double)dpi * bounds.getWidth() / 72.0;
            ((DesignerRepresentation)ifg).setDirty(true);
            Dimension newSize = ifg.getBounds().getCopy().getSize();
            if (dWidthInPixels >= 0.0) {
                newSize.width = (int)dWidthInPixels;
            }
            if (dHeightInPixels >= 0.0) {
                newSize.height = (int)dHeightInPixels;
            }
            ifg.setSize(newSize);
        }
        catch (BirtException ex) {
            logger.log((Exception)((Object)ex));
        }
    }

    public final void disposeFigure(ExtendedItemHandle eih, IFigure ifg) {
        logger.log(1, Messages.getString("ChartReportItemUIImpl.log.ReceivedNotification"));
        ((DesignerRepresentation)ifg).dispose();
        listenerMap.remove(eih);
    }

    private Listener createDeleteChartListener(final DesignElementHandle handleTarget) {
        if (listenerMap.containsKey(handleTarget)) {
            return listenerMap.get(handleTarget);
        }
        Listener listener = new Listener(){

            public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
                DesignElementHandle handleSource;
                ContentEvent cv;
                if (ev instanceof ContentEvent && (cv = (ContentEvent)ev).getAction() == 2 && ((handleSource = handleTarget.getElementProperty("hostChart")) == null || cv.getContent() == handleSource.getElement())) {
                    try {
                        if (handleTarget.getRoot() != null) {
                            handleTarget.dropAndClear();
                        }
                    }
                    catch (SemanticException e) {
                        logger.log((Exception)((Object)e));
                    }
                }
            }
        };
        listenerMap.put(handleTarget, listener);
        return listener;
    }

    private void refreshBackgroundImage(DesignElementHandle handle, ReportElementFigure figure) {
        String backGroundImage = this.getBackgroundImage(handle);
        if (backGroundImage == null) {
            figure.setImage(null);
        } else {
            Image image = null;
            try {
                image = ImageManager.getInstance().getImage(handle.getModuleHandle(), backGroundImage);
            }
            catch (SWTException sWTException) {
                image = null;
            }
            if (image == null) {
                figure.setImage(null);
                return;
            }
            figure.setImage(image);
            Object[] backGroundPosition = this.getBackgroundPosition(handle);
            int backGroundRepeat = this.getBackgroundRepeat(handle);
            figure.setRepeat(backGroundRepeat);
            Object xPosition = backGroundPosition[0];
            Object yPosition = backGroundPosition[1];
            Rectangle area = figure.getClientArea();
            org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
            Point position = new Point(-1, -1);
            int alignment = 0;
            if (xPosition instanceof Integer) {
                position.x = (Integer)xPosition;
            } else if (xPosition instanceof DimensionValue) {
                int percentX = (int)((DimensionValue)xPosition).getMeasure();
                position.x = (area.width - imageArea.width) * percentX / 100;
            } else if (xPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)xPosition));
            }
            if (yPosition instanceof Integer) {
                position.y = (Integer)yPosition;
            } else if (yPosition instanceof DimensionValue) {
                int percentY = (int)((DimensionValue)yPosition).getMeasure();
                position.y = (area.width - imageArea.width) * percentY / 100;
            } else if (yPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)yPosition));
            }
            figure.setAlignment(alignment);
            figure.setPosition(position);
        }
    }

    private String getBackgroundImage(DesignElementHandle handle) {
        return handle.getStringProperty("backgroundImage");
    }

    private Object[] getBackgroundPosition(DesignElementHandle handle) {
        Object x = null;
        Object y = null;
        if (handle != null) {
            Object px = handle.getProperty("backgroundPositionX");
            Object py = handle.getProperty("backgroundPositionY");
            if (px instanceof String) {
                x = px;
            } else if (px instanceof DimensionValue) {
                x = "%".equals(((DimensionValue)px).getUnits()) ? px : Integer.valueOf((int)DEUtil.convertoToPixel((Object)px));
            }
            if (py instanceof String) {
                y = py;
            } else if (py instanceof DimensionValue) {
                y = "%".equals(((DimensionValue)py).getUnits()) ? py : Integer.valueOf((int)DEUtil.convertoToPixel((Object)py));
            }
        }
        return new Object[]{x, y};
    }

    private int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getRepeat(handle.getStringProperty("backgroundRepeat"));
    }

    private int getRepeat(String repeat) {
        if ("repeat-x".equals(repeat)) {
            return 1;
        }
        if ("repeat-y".equals(repeat)) {
            return 2;
        }
        if ("repeat".equals(repeat)) {
            return 3;
        }
        return 0;
    }
}

