/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AngleType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.BlockPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.CustomPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.GeneralPropertiesChartSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    protected FillChooserComposite cmbBackground;
    protected FillChooserComposite fccWall;
    protected FillChooserComposite fccFloor;
    private Combo cmbStyle;
    private Button btnEnablePreview;
    protected ExternalizedTextEditorComposite txtEmptyMsg;
    protected Label lbTxtEmptyMsg;
    protected Label lbFdcEmptyMsg;
    protected FontDefinitionComposite fdcEmptyMsg;
    protected Button btnAutoHide;
    protected Button btnShowEmptyMsg;
    private Button btnResetValue;
    private ChartCheckbox btnEnable;
    private AxisRotationChooser xChooser;
    private AxisRotationChooser yChooser;
    private AxisRotationChooser zChooser;
    protected ChartSpinner spnCorverage;
    private ChartCheckbox btnStudyLayout;
    protected static final int DEFAULT_COVERAGE = 50;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartArea_ID");
        Chart defChart = ChartDefaultValueUtil.getDefaultValueChart((Chart)this.getChart());
        this.init();
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(3, true);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmpBasic.setLayoutData((Object)gd);
        this.initOptionUI(cmpBasic);
        Label lblBackground = new Label(cmpBasic, 0);
        lblBackground.setText(Messages.getString("ChartSheetImpl.Label.Background"));
        this.cmbBackground = new FillChooserComposite(cmpBasic, 0, this.getBackgroundFillStyles(), this.getContext(), this.getChart().getBlock().getBackground());
        GridData gridData = new GridData(768);
        this.cmbBackground.setLayoutData(gridData);
        this.cmbBackground.addListener(this);
        new Label(cmpBasic, 0);
        if (this.hasWallAndFloor()) {
            Label lblWall = new Label(cmpBasic, 0);
            lblWall.setLayoutData((Object)new GridData());
            lblWall.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartWall"));
            this.fccWall = new FillChooserComposite(cmpBasic, 0, this.getContext(), ((ChartWithAxes)this.getChart()).getWallFill(), true, true, true, true);
            GridData gdFCCWall = new GridData(768);
            this.fccWall.setLayoutData(gdFCCWall);
            this.fccWall.addListener(this);
            new Label(cmpBasic, 0);
            Label lblFloor = new Label(cmpBasic, 0);
            lblFloor.setLayoutData((Object)new GridData());
            lblFloor.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartFloor"));
            this.fccFloor = new FillChooserComposite(cmpBasic, 0, this.getContext(), ((ChartWithAxes)this.getChart()).getFloorFill(), true, true, true, true);
            GridData gdFCCFloor = new GridData(768);
            this.fccFloor.setLayoutData(gdFCCFloor);
            this.fccFloor.addListener(this);
            new Label(cmpBasic, 0);
        }
        this.createStyleNPreviewUI(cmpBasic);
        this.createAltMsgComposite(cmpBasic);
        Composite cmp3D = new Composite(this.cmpContent, 0);
        cmp3D.setLayout((Layout)new GridLayout());
        cmp3D.setLayoutData((Object)new GridData(1808));
        this.createAngleChooserComposite(cmp3D);
        this.createCoverageComposite(cmpBasic);
        this.btnEnable = this.getContext().getUIFactory().createChartCheckbox(cmpBasic, 0, defChart.getInteractivity().isEnable());
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        this.btnEnable.setLayoutData((Object)gridData2);
        this.btnEnable.setText(Messages.getString("ChartSheetImpl.Label.InteractivityEnable"));
        this.btnEnable.setSelectionState(!this.getChart().getInteractivity().isSetEnable() ? 0 : (this.getChart().getInteractivity().isEnable() ? 1 : 2));
        this.btnEnable.addSelectionListener((SelectionListener)this);
        if (this.enableStudyLayout()) {
            this.btnStudyLayout = this.getContext().getUIFactory().createChartCheckbox(cmpBasic, 0, ((ChartWithAxes)defChart).isStudyLayout());
            gridData2 = new GridData();
            gridData2.horizontalSpan = 3;
            this.btnStudyLayout.setLayoutData((Object)gridData2);
            this.btnStudyLayout.setText(Messages.getString("ChartSheetImpl.Button.EnableStudyLayout"));
            this.btnStudyLayout.setSelectionState(((ChartWithAxes)this.getChart()).isSetStudyLayout() ? (((ChartWithAxes)this.getChart()).isStudyLayout() ? 1 : 2) : 0);
            this.btnStudyLayout.addSelectionListener((SelectionListener)this);
        }
        this.populateLists();
        this.createButtonGroup(this.cmpContent);
    }

    protected void createCoverageComposite(Composite cmpBasic) {
        if (!(this.getChart() instanceof ChartWithoutAxes)) {
            return;
        }
        ChartWithoutAxes cwa = (ChartWithoutAxes)this.getChart();
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Coverage"));
        Composite cmpCoverage = new Composite(cmpBasic, 0);
        cmpCoverage.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmpCoverage.setLayout((Layout)layout);
        this.spnCorverage = this.getContext().getUIFactory().createChartSpinner(cmpCoverage, 2048, (EObject)cwa, "coverage", true, null, "%");
        this.spnCorverage.setRatio(100.0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.spnCorverage.setLayoutData((Object)gd);
        int spnValue = (int)(cwa.getCoverage() * 100.0);
        if (!cwa.isSetCoverage()) {
            spnValue = 50;
        }
        this.spnCorverage.getWidget().setValues(spnValue, 1, 100, 0, 1, 10);
    }

    protected void createAngleChooserComposite(Composite cmp3D) {
        if (!(this.getChart() instanceof ChartWithAxes) || !this.is3DEnabled()) {
            return;
        }
        Group cmpRotation = new Group(cmp3D, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 0;
        gl.verticalSpacing = 0;
        cmpRotation.setLayout((Layout)gl);
        cmpRotation.setLayoutData((Object)new GridData(768));
        cmpRotation.setText(Messages.getString("ChartLegendImpl.Group.Rotation"));
        this.xChooser = new AxisRotationChooser(ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 1);
        this.xChooser.placeComponents((Composite)cmpRotation);
        this.yChooser = new AxisRotationChooser(ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)0), 2);
        this.yChooser.placeComponents((Composite)cmpRotation);
        this.zChooser = new AxisRotationChooser(ChartUIUtil.getAxisZForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 3);
        this.zChooser.placeComponents((Composite)cmpRotation);
        this.btnResetValue = new Button((Composite)cmpRotation, 8);
        this.btnResetValue.setText(Messages.getString("ChartSheetImpl.Label.ResetValue"));
        this.btnResetValue.setSelection(ChartPreviewPainterBase.isProcessorEnabled());
        this.btnResetValue.addSelectionListener((SelectionListener)this);
    }

    protected void createAltMsgComposite(Composite cmpBasic) {
        Group grpEmptyMsg = new Group(cmpBasic, 0);
        grpEmptyMsg.setText(Messages.getString("ChartSheetImpl.Group.EmptyMessage"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        grpEmptyMsg.setLayoutData((Object)gd);
        grpEmptyMsg.setLayout((Layout)new GridLayout(1, false));
        org.eclipse.birt.chart.model.component.Label laEmptyMsg = this.getChart().getEmptyMessage();
        this.btnAutoHide = new Button((Composite)grpEmptyMsg, 16);
        this.btnAutoHide.setText(Messages.getString("ChartSheetImpl.Button.AutoHide"));
        GridData gd2 = new GridData();
        this.btnAutoHide.setLayoutData((Object)gd2);
        this.btnAutoHide.setSelection(laEmptyMsg.isSetVisible() && !laEmptyMsg.isVisible());
        this.btnAutoHide.addListener(13, (Listener)this);
        this.btnShowEmptyMsg = new Button((Composite)grpEmptyMsg, 16);
        this.btnShowEmptyMsg.setText(Messages.getString("ChartSheetImpl.Button.ShowEmptyMsg"));
        gd2 = new GridData();
        this.btnShowEmptyMsg.setLayoutData((Object)gd2);
        this.btnShowEmptyMsg.setSelection(laEmptyMsg.isSetVisible() && laEmptyMsg.isVisible());
        this.btnShowEmptyMsg.addListener(13, (Listener)this);
        Composite cmpEmptyText = new Composite((Composite)grpEmptyMsg, 0);
        GridData gd3 = new GridData(1808);
        gd3.horizontalIndent = 12;
        cmpEmptyText.setLayoutData((Object)gd3);
        cmpEmptyText.setLayout((Layout)new GridLayout(2, false));
        this.lbTxtEmptyMsg = new Label(cmpEmptyText, 0);
        this.lbTxtEmptyMsg.setText(Messages.getString("ChartSheetImpl.Label.Text"));
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtEmptyMsg = new ExternalizedTextEditorComposite(cmpEmptyText, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), laEmptyMsg.getCaption().getValue());
        GridData gd4 = new GridData(768);
        gd4.widthHint = 200;
        this.txtEmptyMsg.setLayoutData(gd4);
        this.txtEmptyMsg.addListener(this);
        this.lbFdcEmptyMsg = new Label(cmpEmptyText, 0);
        this.lbFdcEmptyMsg.setText(Messages.getString("ChartSheetImpl.Label.Font"));
        this.fdcEmptyMsg = new FontDefinitionComposite(cmpEmptyText, 0, this.getContext(), laEmptyMsg.getCaption().getFont(), laEmptyMsg.getCaption().getColor(), true);
        gd4 = new GridData(768);
        gd4.widthHint = 200;
        gd4.grabExcessVerticalSpace = false;
        this.fdcEmptyMsg.setLayoutData(gd4);
        this.fdcEmptyMsg.addListener(this);
        this.updateEmptyMessageUIStates();
    }

    protected boolean enableStudyLayout() {
        return ChartUtil.hasMultipleYAxes((Chart)this.getChart());
    }

    protected void createStyleNPreviewUI(Composite cmpBasic) {
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Style"));
        this.cmbStyle = new Combo(cmpBasic, 12);
        GridData gridData = new GridData(768);
        this.cmbStyle.setLayoutData((Object)gridData);
        this.cmbStyle.addSelectionListener((SelectionListener)this);
        this.btnEnablePreview = new Button(cmpBasic, 32);
        this.btnEnablePreview.setText(Messages.getString("ChartSheetImpl.Label.EnableInPreview"));
        this.btnEnablePreview.setSelection(ChartPreviewPainterBase.isProcessorEnabled());
        this.btnEnablePreview.addSelectionListener((SelectionListener)this);
    }

    protected boolean is3DEnabled() {
        return ChartUIUtil.is3DType((Chart)this.getChart());
    }

    protected void initOptionUI(Composite cmpBasic) {
    }

    private void init() {
        if (this.getChart().getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)this.getChart().eAdapters());
            this.getChart().setInteractivity(interactivity);
        }
    }

    private void populateLists() {
        if (this.cmbStyle == null) {
            return;
        }
        IDataServiceProvider idsp = this.getContext().getDataServiceProvider();
        if (idsp != null) {
            String[] allStyleNames = idsp.getAllStyles();
            String[] displayNames = idsp.getAllStyleDisplayNames();
            String[] selection = new String[displayNames.length + 1];
            System.arraycopy(displayNames, 0, selection, 1, displayNames.length);
            selection[0] = Messages.getString("ChartSheetImpl.Label.None");
            this.cmbStyle.setItems(selection);
            this.cmbStyle.setData((Object)allStyleNames);
            String sStyle = idsp.getCurrentStyle();
            int idx = this.getStyleIndex(sStyle);
            this.cmbStyle.select(idx + 1);
        }
    }

    private int getStyleIndex(String style) {
        String[] allStyleNames = (String[])this.cmbStyle.getData();
        if (style != null && allStyleNames != null) {
            int i = 0;
            while (i < allStyleNames.length) {
                if (style.equals(allStyleNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new BlockPropertiesSheet(Messages.getString("ChartSheetImpl.Text.Outline"), this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, ".Outline", Messages.getString("ChartSheetImpl.Text.Outline&"), popup);
        btnBlockProp.addSelectionListener((SelectionListener)this);
        popup = new GeneralPropertiesChartSheet(Messages.getString("ChartSheetImpl.Text.GeneralProperties"), this.getContext());
        Button btnGeneralProp = this.createToggleButton(cmp, ".General", Messages.getString("ChartSheetImpl.Text.GeneralProperties&"), popup);
        btnGeneralProp.addSelectionListener((SelectionListener)this);
        popup = new CustomPropertiesSheet(Messages.getString("ChartSheetImpl.Text.CustomProperties"), this.getContext());
        Button btnCustomProp = this.createToggleButton(cmp, ".Custom", Messages.getString("ChartSheetImpl.Text.CustomProperties&"), popup);
        btnCustomProp.addSelectionListener((SelectionListener)this);
        if (this.getContext().isInteractivityEnabled()) {
            popup = new InteractivitySheet(Messages.getString("ChartSheetImpl.Label.Interactivity"), this.getContext(), (EList<Trigger>)this.getChart().getBlock().getTriggers(), (EObject)this.getChart().getBlock(), 4, 16);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
    }

    protected int getBackgroundFillStyles() {
        return 31;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.cmbBackground)) {
            this.getChart().getBlock().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccWall)) {
            if (this.hasWallAndFloor()) {
                ((ChartWithAxes)this.getChart()).setWallFill((Fill)event.data);
            }
        } else if (event.widget.equals((Object)this.fccFloor)) {
            if (this.hasWallAndFloor()) {
                ((ChartWithAxes)this.getChart()).setFloorFill((Fill)event.data);
            }
        } else if (event.widget == this.txtEmptyMsg) {
            this.getChart().getEmptyMessage().getCaption().setValue(this.txtEmptyMsg.getText());
        } else if (event.widget == this.btnAutoHide || event.widget == this.btnShowEmptyMsg) {
            this.getChart().getEmptyMessage().setVisible(!this.btnAutoHide.getSelection());
            this.updateEmptyMessageUIStates();
        } else if (event.widget == this.fdcEmptyMsg) {
            Text caption = this.getChart().getEmptyMessage().getCaption();
            caption.setFont((FontDefinition)((Object[])event.data)[0]);
            caption.setColor((ColorDefinition)((Object[])event.data)[1]);
        }
    }

    protected void updateEmptyMessageUIStates() {
        boolean bEnabled = this.getChart().getEmptyMessage().isVisible();
        this.txtEmptyMsg.setEnabled(bEnabled);
        this.fdcEmptyMsg.setEnabled(bEnabled);
        this.lbTxtEmptyMsg.setEnabled(bEnabled);
        this.lbFdcEmptyMsg.setEnabled(bEnabled);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.cmbStyle)) {
            String[] allStyleNames = (String[])this.cmbStyle.getData();
            String sStyle = null;
            int idx = this.cmbStyle.getSelectionIndex();
            if (idx > 0) {
                sStyle = allStyleNames[idx - 1];
            }
            this.getContext().getDataServiceProvider().setStyle(sStyle);
            if (this.btnEnablePreview.getSelection()) {
                this.refreshPreview();
            }
        } else if (e.widget.equals(this.btnEnablePreview)) {
            ChartPreviewPainterBase.enableProcessor((boolean)this.btnEnablePreview.getSelection());
            this.refreshPreview();
        } else if (e.widget.equals(this.btnEnable)) {
            int state = this.btnEnable.getSelectionState();
            ChartElementUtil.setEObjectAttribute((EObject)this.getChart().getInteractivity(), (String)"enable", (Object)(state == 1 ? 1 : 0), (state == 0 ? 1 : 0) != 0);
            this.setToggleButtonEnabled(".Interactivity", state == 1);
            if (this.getToggleButtonSelection(".Interactivity")) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.btnResetValue)) {
            if (!this.xChooser.isAutoAngle()) {
                this.setAxisAngle(1, -20);
                this.xChooser.txtRotation.setValue(-20.0);
            }
            if (!this.yChooser.isAutoAngle()) {
                this.setAxisAngle(2, 45);
                this.yChooser.txtRotation.setValue(45.0);
            }
            if (!this.zChooser.isAutoAngle()) {
                this.setAxisAngle(3, 0);
                this.zChooser.txtRotation.setValue(0.0);
            }
        } else if (e.widget == this.btnStudyLayout && this.getChart() instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)this.getChart();
            if (this.btnStudyLayout.getSelectionState() == 0) {
                cwa.unsetStudyLayout();
            } else {
                cwa.setStudyLayout(this.btnStudyLayout.getSelectionState() == 1);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshPreview() {
        boolean currentValue = this.getChart().getTitle().isVisible();
        ChartAdapter.ignoreNotifications((boolean)true);
        this.getChart().getTitle().setVisible(!currentValue);
        ChartAdapter.ignoreNotifications((boolean)false);
        this.getChart().getTitle().setVisible(currentValue);
    }

    protected boolean hasWallAndFloor() {
        return this.getChart() instanceof ChartWithAxes && this.getChart().getDimension().getValue() != 0;
    }

    private void setAxisAngle(int angleType, int angleDegree) {
        Angle3D angle3D = this.getAngle3D();
        angle3D.setType(AngleType.NONE_LITERAL);
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().clear();
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().add((Object)angle3D);
        switch (angleType) {
            case 1: {
                angle3D.setXAngle((double)angleDegree);
                break;
            }
            case 2: {
                angle3D.setYAngle((double)angleDegree);
                break;
            }
            case 3: {
                angle3D.setZAngle((double)angleDegree);
            }
        }
    }

    private Angle3D getAngle3D() {
        return (Angle3D)((ChartWithAxes)this.getChart()).getRotation().getAngles().get(0);
    }

    private class AxisRotationChooser
    implements SelectionListener,
    ModifyListener {
        private Button btnAntiRotation;
        private Button btnRotation;
        private AbstractChartNumberEditor txtRotation;
        private int angleType;

        public AxisRotationChooser(Axis axis, int angleType) {
            this.angleType = angleType;
        }

        public void placeComponents(Composite parent) {
            Composite context = new Composite(parent, 0);
            GridLayout gl = new GridLayout(4, false);
            gl.horizontalSpacing = 8;
            context.setLayout((Layout)gl);
            context.setLayoutData((Object)new GridData(768));
            this.btnAntiRotation = new Button(context, 8);
            GridData gd = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gd);
            this.btnAntiRotation.setLayoutData((Object)gd);
            this.btnAntiRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, true)));
            this.btnAntiRotation.addSelectionListener((SelectionListener)this);
            this.btnRotation = new Button(context, 8);
            gd = new GridData();
            gd.widthHint = 20;
            gd.heightHint = 20;
            this.btnRotation.setLayoutData((Object)gd);
            this.btnRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, false)));
            this.btnRotation.addSelectionListener((SelectionListener)this);
            this.txtRotation = ChartSheetImpl.this.getContext().getUIFactory().createChartNumberEditor(context, 2052, null, (EObject)ChartSheetImpl.this.getAngle3D(), this.getAxisAngleProperty(this.angleType));
            new RotationEditorAssistField((LocalizedNumberEditorComposite)this.txtRotation, null);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.txtRotation.setLayoutData((Object)gd);
            this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            this.txtRotation.addModifyListener((ModifyListener)this);
            this.updateUIState(this.txtRotation.getTextControl().isEnabled());
        }

        private boolean isAutoAngle() {
            return !ChartElementUtil.isSetEObjectAttribute((EObject)ChartSheetImpl.this.getAngle3D(), (String)this.getAxisAngleProperty(this.angleType));
        }

        private void updateUIState(boolean enabled) {
            this.btnAntiRotation.setEnabled(enabled);
            this.btnRotation.setEnabled(enabled);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnAntiRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) - 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            } else if (e.widget.equals(this.btnRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) + 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget.equals(this.txtRotation)) {
                if (!"Reset".equals(e.data)) {
                    ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.txtRotation.getValue());
                }
                this.updateUIState(this.txtRotation.getTextControl().isEnabled());
            }
        }

        private String getImagePath(int angleType, boolean bAntiRotation) {
            String basePath = "icons/obj16/";
            String filename = null;
            switch (angleType) {
                case 1: {
                    filename = bAntiRotation ? "x_rotation.gif" : "x_anti_rotation.gif";
                    break;
                }
                case 2: {
                    filename = bAntiRotation ? "y_anti_rotation.gif" : "y_rotation.gif";
                    break;
                }
                case 3: {
                    filename = bAntiRotation ? "z_rotation.gif" : "z_anti_rotation.gif";
                }
            }
            return String.valueOf(basePath) + filename;
        }

        private double getAxisAngle(int angleType) {
            switch (angleType) {
                case 1: {
                    return ChartSheetImpl.this.getAngle3D().getXAngle();
                }
                case 2: {
                    return ChartSheetImpl.this.getAngle3D().getYAngle();
                }
                case 3: {
                    return ChartSheetImpl.this.getAngle3D().getZAngle();
                }
            }
            return 0.0;
        }

        private String getAxisAngleProperty(int angleType) {
            switch (angleType) {
                case 1: {
                    return "xAngle";
                }
                case 2: {
                    return "yAngle";
                }
                case 3: {
                    return "zAngle";
                }
            }
            return "xAngle";
        }
    }

    static class RotationEditorAssistField
    extends TextNumberEditorAssistField {
        public RotationEditorAssistField(LocalizedNumberEditorComposite numberEditor, Composite composite) {
            super(numberEditor.getTextControl(), composite);
        }

        public boolean isValid() {
            String contents = this.getContents();
            if (contents == null || "".equals(contents.trim())) {
                return true;
            }
            char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (Character.isDigit(ch = contents.charAt(i++)) || ch == '.' || ch == '-' || ch == '+' || ch == groupingSeparator) continue;
                return false;
            }
            return true;
        }

        public void quickFix() {
            String contents = this.getContents();
            StringBuffer numbersOnly = new StringBuffer();
            char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (!Character.isDigit(ch = contents.charAt(i++)) && ch != '.' && ch != '-' && ch != '+' && ch != groupingSeparator) continue;
                numbersOnly.append(ch);
            }
            this.setContents(numbersOnly.toString());
        }
    }
}

