/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DeleteWarningDialog;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.ui.PlatformUI;

public class OlapUtil {
    public static final String DLG_REFERENCE_FOUND_TITLE = Messages.getString("GroupsPage.Reference");
    public static final String DLG_HAS_FOLLOWING_CLIENTS_MSG = Messages.getString("GroupsPage.Clients");
    public static final String DLG_CONFIRM_MSG = Messages.getString("GroupsPage.Dlg.Confirm");
    private static IChoiceSet choiceSet = MetaDataDictionary.getInstance().getElement("TabularLevel").getProperty("dateTimeLevelType").getAllowedChoices();
    private static IChoice[] DATE_TIME_LEVEL_TYPE_ALL = choiceSet.getChoices();
    private static IChoice[] DATE_LEVEL_TYPE_ALL;
    private static IChoice[] TIME_LEVEL_TYPE_ALL;

    static {
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        choiceList.addAll(Arrays.asList(choiceSet.getChoices()));
        choiceList.remove(choiceSet.findChoice("hour"));
        choiceList.remove(choiceSet.findChoice("minute"));
        choiceList.remove(choiceSet.findChoice("second"));
        DATE_LEVEL_TYPE_ALL = choiceList.toArray(new IChoice[0]);
        choiceList.clear();
        choiceList.add(choiceSet.findChoice("hour"));
        choiceList.add(choiceSet.findChoice("minute"));
        choiceList.add(choiceSet.findChoice("second"));
        TIME_LEVEL_TYPE_ALL = choiceList.toArray(new IChoice[0]);
    }

    public static String[] getDataFieldNames(DataSetHandle dataset) {
        if (dataset == null) {
            return new String[0];
        }
        String[] columns = new String[]{};
        try {
            List columnList = DataUtil.getColumnList((DataSetHandle)dataset);
            columns = new String[columnList.size()];
            int i = 0;
            while (i < columnList.size()) {
                ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)columnList.get(i);
                columns[i] = resultSetColumn.getColumnName();
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return columns;
    }

    public static String getDataFieldDisplayName(ResultSetColumnHandle column) {
        if (column == null) {
            return null;
        }
        DataSetHandle dataset = (DataSetHandle)column.getElementHandle();
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias()) || element.getDisplayName() == null || element.getDisplayName().length() <= 0) continue;
            return element.getDisplayName();
        }
        return column.getColumnName();
    }

    public static ColumnHintHandle getColumnHintHandle(ResultSetColumnHandle column) {
        if (column == null) {
            return null;
        }
        DataSetHandle dataset = (DataSetHandle)column.getElementHandle();
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element;
        }
        return null;
    }

    public static String[] getDataFieldDisplayNames(DataSetHandle dataset) {
        if (dataset == null) {
            return new String[0];
        }
        String[] columns = new String[]{};
        try {
            List columnList = DataUtil.getColumnList((DataSetHandle)dataset);
            columns = new String[columnList.size()];
            int i = 0;
            while (i < columnList.size()) {
                ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)columnList.get(i);
                columns[i] = OlapUtil.getDataFieldDisplayName(resultSetColumn);
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return columns;
    }

    public static ResultSetColumnHandle[] getDataFields(DataSetHandle dataset) {
        if (dataset == null) {
            return new ResultSetColumnHandle[0];
        }
        ResultSetColumnHandle[] columns = new ResultSetColumnHandle[]{};
        try {
            List columnList = DataUtil.getColumnList((DataSetHandle)dataset);
            columns = new ResultSetColumnHandle[columnList.size()];
            int i = 0;
            while (i < columnList.size()) {
                ResultSetColumnHandle resultSetColumn;
                columns[i] = resultSetColumn = (ResultSetColumnHandle)columnList.get(i);
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return columns;
    }

    public static ResultSetColumnHandle getDataField(DataSetHandle dataset, String fieldName) {
        if (dataset == null || fieldName == null) {
            return null;
        }
        try {
            List columnList = DataUtil.getColumnList((DataSetHandle)dataset);
            int i = 0;
            while (i < columnList.size()) {
                ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)columnList.get(i);
                if (fieldName.equals(resultSetColumn.getColumnName())) {
                    return resultSetColumn;
                }
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return null;
    }

    public static String[] getAvailableDatasetNames() {
        SlotHandle slot = SessionHandleAdapter.getInstance().getReportDesignHandle().getDataSets();
        if (slot == null || slot.getCount() == 0) {
            return new String[0];
        }
        String[] datasets = new String[slot.getCount()];
        int i = 0;
        while (i < slot.getCount()) {
            DataSetHandle dataset = (DataSetHandle)slot.get(i);
            datasets[i] = dataset.getName();
            ++i;
        }
        return datasets;
    }

    public static DataSetHandle[] getAvailableDatasets() {
        SlotHandle slot = SessionHandleAdapter.getInstance().getReportDesignHandle().getDataSets();
        if (slot == null || slot.getCount() == 0) {
            return new DataSetHandle[0];
        }
        DataSetHandle[] datasets = new DataSetHandle[slot.getCount()];
        int i = 0;
        while (i < slot.getCount()) {
            datasets[i] = (DataSetHandle)slot.get(i);
            ++i;
        }
        return datasets;
    }

    public static int getIndexOfPrimaryDataset(DataSetHandle dataset) {
        SlotHandle slot = SessionHandleAdapter.getInstance().getReportDesignHandle().getDataSets();
        if (slot == null || slot.getCount() == 0) {
            return -1;
        }
        int i = 0;
        while (i < slot.getCount()) {
            if (slot.get(i) == dataset) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static DataSetHandle getDataset(String datasetName) {
        SlotHandle slot = SessionHandleAdapter.getInstance().getReportDesignHandle().getDataSets();
        if (slot == null || slot.getCount() == 0) {
            return null;
        }
        int i = 0;
        while (i < slot.getCount()) {
            if (((DataSetHandle)slot.get(i)).getName().equals(datasetName)) {
                return (DataSetHandle)slot.get(i);
            }
            ++i;
        }
        return null;
    }

    public static boolean enableDrop(Object model) {
        if (model instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)model;
            ArrayList referenceList = new ArrayList();
            Iterator itor = handle.clientsIterator();
            while (itor.hasNext()) {
                referenceList.add(itor.next());
            }
            if (!referenceList.isEmpty()) {
                DeleteWarningDialog dialog = new DeleteWarningDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DLG_REFERENCE_FOUND_TITLE, referenceList);
                dialog.setPreString(String.valueOf(DEUtil.getDisplayLabel((Object)handle)) + DLG_HAS_FOLLOWING_CLIENTS_MSG);
                dialog.setSufString(DLG_CONFIRM_MSG);
                return dialog.open() != 1;
            }
            return true;
        }
        return true;
    }

    public static boolean isFromLibrary(Object model) {
        if (model instanceof DesignElementHandle) {
            return DEUtil.isLinkedElement((DesignElementHandle)((DesignElementHandle)model));
        }
        return false;
    }

    public static DataSetHandle getHierarchyDataset(TabularHierarchyHandle hierarchy) {
        if (hierarchy == null) {
            return null;
        }
        DataSetHandle dataset = hierarchy.getDataSet();
        if (dataset == null && hierarchy.getLevelCount() > 0 && hierarchy.getContainer().getContainer() instanceof TabularCubeHandle) {
            dataset = ((TabularCubeHandle)hierarchy.getContainer().getContainer()).getDataSet();
        }
        return dataset;
    }

    public static IChoiceSet getDateTimeLevelTypeChoiceSet() {
        return choiceSet;
    }

    public static IChoice[] getDateTimeLevelTypeChoices() {
        return DATE_TIME_LEVEL_TYPE_ALL;
    }

    public static IChoice[] getDateLevelTypeChoices() {
        return DATE_LEVEL_TYPE_ALL;
    }

    public static IChoice[] getTimeLevelTypeChoices() {
        return TIME_LEVEL_TYPE_ALL;
    }
}

