/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ChangeAreaCommand
extends AbstractCrosstabCommand {
    private int type = -1;
    private Object after = null;
    DimensionViewHandle parentVewHandle;
    DimensionViewHandle childViewHandle;
    private AggregationCellProviderWrapper providerWrapper;
    private static final String NAME = Messages.getString("ChangeAreaCommand.TransName");

    public ChangeAreaCommand(DesignElementHandle parent, DesignElementHandle child, Object after) {
        super(child);
        this.after = after;
        if (parent != null) {
            this.parentVewHandle = CrosstabAdaptUtil.getDimensionViewHandle(CrosstabAdaptUtil.getExtendedItemHandle(parent));
            this.setType(this.parentVewHandle.getAxisType());
        }
        this.childViewHandle = CrosstabAdaptUtil.getDimensionViewHandle(CrosstabAdaptUtil.getExtendedItemHandle(child));
        this.providerWrapper = new AggregationCellProviderWrapper(this.childViewHandle.getCrosstab());
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.childViewHandle.getCrosstab().getCrosstabHandle());
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle reportHandle = this.childViewHandle.getCrosstab();
        try {
            boolean bool = CrosstabAdaptUtil.needRemoveInvaildBindings(reportHandle);
            reportHandle.pivotDimension(this.childViewHandle.getAxisType(), this.childViewHandle.getIndex(), this.getType(), this.findPosition());
            CrosstabUtil.addAllHeaderLabel((CrosstabReportItemHandle)reportHandle);
            if (bool) {
                CrosstabAdaptUtil.removeInvalidBindings(reportHandle);
            }
            this.providerWrapper.updateAllAggregationCells();
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionUtil.handle((Throwable)e);
        }
        this.transEnd();
    }

    private int findPosition() {
        int index;
        if (this.parentVewHandle == null) {
            return 0;
        }
        int ori = this.childViewHandle.getIndex();
        int base = this.parentVewHandle.getIndex();
        int value = 0;
        if (ori < base && this.getType() == this.childViewHandle.getAxisType()) {
            value = -1;
        }
        if (this.after instanceof DesignElementHandle && (index = ((DesignElementHandle)this.after).getIndex()) == 0) {
            return base + value;
        }
        return base + 1 + value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

