/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class AddressPane
extends AbstractPane {
    public AddressPane(Rendering parent) {
        super(parent);
    }

    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    protected void appendSelection(int x, int y) {
        try {
            if (this.fSelectionStartAddress == null) {
                return;
            }
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address.compareTo(this.fSelectionStartAddress) == 0) {
                this.fRendering.getSelection().setEnd(null, null);
            } else {
                this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn() * this.fRendering.getColumnCount())), address);
            }
        }
        catch (DebugException e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_APPEND_SELECTION"), (Exception)((Object)e));
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    protected int getCellCharacterCount() {
        return this.fRendering.getAddressBytes() * 2 + 2;
    }

    protected int getCellWidth() {
        GC gc = new GC((Drawable)this);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.getCellCharacterCount()) {
            buf.append("0");
            ++i;
        }
        int width = gc.textExtent((String)buf.toString()).x;
        gc.dispose();
        return width;
    }

    private int getColumnCount() {
        return 0;
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col > this.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn() / this.fRendering.getBytesPerCharacter()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            cellOffset *= this.fRendering.getAddressableSize();
            if (this.fRendering.getColumnCount() == 0) {
                return new Point(0, 0);
            }
            int row = cellOffset / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    protected int getNumberOfBytesRepresentedByColumn() {
        return this.fRendering.getBytesPerRow();
    }

    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int x2 = offset / this.getCellCharacterWidth();
                if (x2 >= this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.getNumberOfBytesRepresentedByColumn()));
                    x2 = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + x2 * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = x2;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    protected void paint(PaintEvent pe) {
        super.paint(pe);
        GC gc = pe.gc;
        FontMetrics fontMetrics = gc.getFontMetrics();
        int textHeight = fontMetrics.getHeight();
        int cellHeight = textHeight + this.fRendering.getCellPadding() * 2;
        try {
            BigInteger start = this.fRendering.getViewportStartAddress();
            int i = 0;
            while (i < this.getBounds().height / cellHeight) {
                gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
                BigInteger lineAddress = start.add(BigInteger.valueOf(i * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn()));
                if (this.fRendering.getSelection().isSelected(lineAddress)) {
                    gc.setBackground(this.fRendering.getTraditionalRendering().getColorSelection());
                    gc.fillRectangle(this.fRendering.getCellPadding() * 2, cellHeight * i, this.getCellWidth(), cellHeight);
                    gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
                } else {
                    gc.setBackground(this.fRendering.getTraditionalRendering().getColorBackground());
                    gc.fillRectangle(this.fRendering.getCellPadding() * 2, cellHeight * i, this.getCellWidth(), cellHeight);
                    this.applyCustomColor(gc);
                }
                gc.drawText(this.fRendering.getAddressString(lineAddress), this.fRendering.getCellPadding() * 2, cellHeight * i + this.fRendering.getCellPadding());
                ++i;
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_PAINT"), e);
        }
    }

    protected void applyCustomColor(GC gc) {
        gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
    }
}

