/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

public class BasicTopologyManager
extends AbstractTopologyManager
implements EventHook,
EndpointListener {
    private static final boolean allowLoopbackReference = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.discovery.allowLoopbackReference", "false"));
    private static final String endpointListenerScope = System.getProperty("org.eclipse.ecf.osgi.services.discovery.endpointListenerScope");
    private boolean exportRegisteredSvcs = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.basictopologymanager.exportRegisteredSvcs", "true"));
    private String exportRegisteredSvcsClassname = System.getProperty("org.eclipse.ecf.osgi.services.basictopologymanager.exportRegisteredSvcsClassname");
    private String exportRegisteredSvcsFilter = System.getProperty("org.eclipse.ecf.osgi.services.basictopologymanager.exportRegisteredSvcsFilter", "(service.exported.interfaces=*)");
    private ServiceRegistration endpointListenerRegistration;
    private ServiceRegistration eventHookRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BasicTopologyManager(BundleContext context) {
        super(context);
    }

    public void setExportRegisteredSvcs(boolean val) {
        this.exportRegisteredSvcs = val;
    }

    public void setExportRegisteredSvcsClassname(String classname) {
        this.exportRegisteredSvcsClassname = classname;
    }

    public void setExportRegisteredSvcsFilter(String filter) {
        this.exportRegisteredSvcsFilter = filter;
    }

    private String getEndpointListenerScope() {
        if (endpointListenerScope != null) {
            return endpointListenerScope;
        }
        StringBuffer elScope = new StringBuffer("(");
        if (allowLoopbackReference) {
            elScope.append("endpoint.id");
            elScope.append("=*");
        } else {
            elScope.append("!(");
            elScope.append("endpoint.framework.uuid");
            elScope.append("=");
            elScope.append(this.getFrameworkUUID());
            elScope.append(")");
        }
        elScope.append(")");
        String result = elScope.toString();
        this.trace("getEndpointListenerScope", "endpointListenerScope=" + result);
        return result;
    }

    public void exportRegisteredServices(String exportRegisteredSvcsClassname, String exportRegisteredSvcsFilter) {
        ServiceReference[] existingServiceRefs = null;
        try {
            existingServiceRefs = this.getContext().getAllServiceReferences(exportRegisteredSvcsClassname, exportRegisteredSvcsFilter);
        }
        catch (InvalidSyntaxException e) {
            this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsClassname=" + exportRegisteredSvcsClassname + " and exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
        }
        if (existingServiceRefs != null) {
            int i = 0;
            while (i < existingServiceRefs.length) {
                this.handleServiceRegistering(existingServiceRefs[i]);
                ++i;
            }
        }
    }

    public void start() throws Exception {
        Properties props = new Properties();
        props.put("endpoint.listener.scope", this.getEndpointListenerScope());
        BundleContext bundleContext = this.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.remoteserviceadmin.EndpointListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.endpointListenerRegistration = bundleContext.registerService(clazz.getName(), (Object)this, (Dictionary)props);
        BundleContext bundleContext2 = this.getContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = bundleContext2.registerService(clazz2.getName(), (Object)this, null);
        if (this.exportRegisteredSvcs) {
            this.exportRegisteredServices(this.exportRegisteredSvcsClassname, this.exportRegisteredSvcsFilter);
        }
    }

    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointAdded(endpoint, matchedFilter);
    }

    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointRemoved(endpoint, matchedFilter);
    }

    public void event(ServiceEvent event, Collection contexts) {
        this.handleEvent(event, contexts);
    }

    public void close() {
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
        if (this.endpointListenerRegistration != null) {
            this.endpointListenerRegistration.unregister();
            this.endpointListenerRegistration = null;
        }
        super.close();
    }
}

