/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.core.AdvertisedService;
import org.eclipse.ecf.provider.zookeeper.core.internal.Localizer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.eclipse.ecf.provider.zookeeper.node.internal.INode;
import org.eclipse.ecf.provider.zookeeper.node.internal.WriteRoot;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

public class NodeWriter {
    private INode node;
    private String ip;
    private WriteRoot writeRoot;

    public NodeWriter(INode node, WriteRoot writeRoot) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)writeRoot);
        this.writeRoot = writeRoot;
        this.node = node;
    }

    public String getPath() {
        return this.node.getPath();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public synchronized void publish() {
        try {
            String parentPath = this.getNode().getAbsolutePath();
            Stat stat = this.writeRoot.getWriteKeeper().exists(parentPath, false);
            if (stat == null) {
                this.writeRoot.getWriteKeeper().create(parentPath, ((AdvertisedService)this.getNode().getWrappedService()).getPropertiesAsBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            PrettyPrinter.prompt(1, this.getNode().getWrappedService());
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                Logger.log(1, "Can't connect to server! " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void remove() {
        if (this.writeRoot.isConnected()) {
            try {
                String nodePath = this.getNode().getAbsolutePath();
                Stat stat = this.writeRoot.getWriteKeeper().exists(nodePath, false);
                if (stat == null) {
                    return;
                }
                this.writeRoot.getWriteKeeper().delete(nodePath, -1);
                Localizer.getSingleton().localize(new Notification(this.getNode().getWrappedService(), 2));
                PrettyPrinter.prompt(2, this.getNode().getWrappedService());
            }
            catch (KeeperException keeperException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (!this.writeRoot.isConnected() && this.writeRoot.getWatchManager().getConfig().isCentralized()) {
            PrettyPrinter.prompt(2, this.getNode().getWrappedService());
        }
    }

    public INode getNode() {
        return this.node;
    }
}

