/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.server.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.server.generic.GenericServerContainerGroup;
import org.eclipse.ecf.server.generic.GenericServerContainerGroupCreateException;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroup;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroupFactory;

public class GenericServerContainerGroupFactory
implements IGenericServerContainerGroupFactory {
    private Hashtable serverContainerGroups = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenericServerContainerGroup createContainerGroup(String hostname, int port, Map defaultContainerProperties) throws GenericServerContainerGroupCreateException {
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            SCGData scgdata = new SCGData(hostname, port);
            if (this.serverContainerGroups.contains(scgdata)) {
                throw new GenericServerContainerGroupCreateException("Cannot container group hostname=" + hostname + " port=" + port + " already exists");
            }
            IGenericServerContainerGroup scg = this.createGenericServerContainerGroup(scgdata, defaultContainerProperties);
            this.serverContainerGroups.put(scgdata, scg);
            return scg;
        }
    }

    protected IGenericServerContainerGroup createGenericServerContainerGroup(SCGData scgdata, Map defaultContainerProperties) throws GenericServerContainerGroupCreateException {
        return new GenericServerContainerGroup(scgdata.getHostname(), scgdata.getPort(), defaultContainerProperties);
    }

    public IGenericServerContainerGroup createContainerGroup(String hostname, int port) throws GenericServerContainerGroupCreateException {
        return this.createContainerGroup(hostname, port, null);
    }

    public IGenericServerContainerGroup createContainerGroup(String hostname) throws GenericServerContainerGroupCreateException {
        return this.createContainerGroup(hostname, 3282);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            Iterator i = this.serverContainerGroups.keySet().iterator();
            while (i.hasNext()) {
                SCGData scgdata = (SCGData)i.next();
                IGenericServerContainerGroup scg = (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
                scg.close();
            }
        }
        this.serverContainerGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenericServerContainerGroup getContainerGroup(String hostname, int port) {
        if (hostname == null) {
            return null;
        }
        SCGData scgdata = new SCGData(hostname, port);
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            return (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenericServerContainerGroup[] getContainerGroups() {
        ArrayList<IGenericServerContainerGroup> results = new ArrayList<IGenericServerContainerGroup>();
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            Iterator i = this.serverContainerGroups.keySet().iterator();
            while (i.hasNext()) {
                SCGData scgdata = (SCGData)i.next();
                IGenericServerContainerGroup gscg = (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
                if (gscg == null) continue;
                results.add(gscg);
            }
        }
        return results.toArray(new IGenericServerContainerGroup[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenericServerContainerGroup removeContainerGroup(String hostname, int port) {
        if (hostname == null) {
            return null;
        }
        SCGData scgdata = new SCGData(hostname, port);
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            return (IGenericServerContainerGroup)this.serverContainerGroups.remove(scgdata);
        }
    }

    class SCGData {
        private String hostname;
        private int port;

        SCGData(String hostname, int port) {
            Assert.isNotNull((Object)hostname);
            Assert.isTrue((port > 0 ? 1 : 0) != 0);
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SCGData)) {
                return false;
            }
            SCGData o = (SCGData)other;
            return this.hostname.equals(o.hostname) && this.port == o.port;
        }

        public int hashCode() {
            return this.hostname.hashCode() ^ this.port;
        }
    }
}

