/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexBlobStorage;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

class IndexFileRevision
extends GitFileRevision {
    private static final int FIRST_AVAILABLE = -1;
    private final Repository db;
    private final String path;
    private final int stage;
    private ObjectId blobId;

    IndexFileRevision(Repository repo, String fileName) {
        this(repo, fileName, -1);
    }

    IndexFileRevision(Repository repo, String fileName, int stage) {
        super(fileName);
        this.db = repo;
        this.path = fileName;
        this.stage = stage;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.blobId = this.locateBlobObjectId();
        }
        return new IndexBlobStorage(this.db, this.path, this.blobId);
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return null;
    }

    public String getContentIdentifier() {
        return "Index";
    }

    private ObjectId locateBlobObjectId() throws CoreException {
        int firstIndex;
        DirCache dc;
        block6: {
            dc = this.db.readDirCache();
            firstIndex = dc.findEntry(this.path);
            if (firstIndex >= 0) break block6;
            return null;
        }
        try {
            DirCacheEntry firstEntry = dc.getEntry(firstIndex);
            if (this.stage == -1 || firstEntry.getStage() == this.stage) {
                return firstEntry.getObjectId();
            }
            int nextIndex = dc.nextEntry(firstIndex);
            int i = firstIndex;
            while (i < nextIndex) {
                DirCacheEntry entry = dc.getEntry(i);
                if (entry.getStage() == this.stage) {
                    return entry.getObjectId();
                }
                ++i;
            }
            return null;
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.IndexFileRevision_errorLookingUpPath, (Object)this.path), e));
        }
    }
}

