/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneOperation {
    private final URIish uri;
    private final boolean allSelected;
    private boolean cloneSubmodules;
    private final Collection<Ref> selectedBranches;
    private final File workdir;
    private final File gitdir;
    private final String refName;
    private final String remoteName;
    private final int timeout;
    private CredentialsProvider credentialsProvider;
    private List<PostCloneTask> postCloneTasks;

    public CloneOperation(URIish uri, boolean allSelected, Collection<Ref> selectedBranches, File workdir, String refName, String remoteName, int timeout) {
        this.uri = uri;
        this.allSelected = allSelected;
        this.selectedBranches = selectedBranches;
        this.workdir = workdir;
        this.gitdir = new File(workdir, ".git");
        this.refName = refName;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setCloneSubmodules(boolean cloneSubmodules) {
        this.cloneSubmodules = cloneSubmodules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        Object monitor = pm == null ? new NullProgressMonitor() : pm;
        EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)monitor);
        Repository repository = null;
        try {
            try {
                monitor.beginTask(NLS.bind((String)CoreText.CloneOperation_title, (Object)this.uri), 5000);
                CloneCommand cloneRepository = Git.cloneRepository();
                cloneRepository.setCredentialsProvider(this.credentialsProvider);
                if (this.refName != null) {
                    cloneRepository.setBranch(this.refName);
                } else {
                    cloneRepository.setNoCheckout(true);
                }
                cloneRepository.setDirectory(this.workdir);
                cloneRepository.setProgressMonitor((ProgressMonitor)gitMonitor);
                cloneRepository.setRemote(this.remoteName);
                cloneRepository.setURI(this.uri.toString());
                cloneRepository.setTimeout(this.timeout);
                cloneRepository.setCloneAllBranches(this.allSelected);
                cloneRepository.setCloneSubmodules(this.cloneSubmodules);
                if (this.selectedBranches != null) {
                    ArrayList<String> branches = new ArrayList<String>();
                    for (Ref branch : this.selectedBranches) {
                        branches.add(branch.getName());
                    }
                    cloneRepository.setBranchesToClone(branches);
                }
                Git git = cloneRepository.call();
                repository = git.getRepository();
                CloneOperation cloneOperation = this;
                synchronized (cloneOperation) {
                    if (this.postCloneTasks != null) {
                        for (PostCloneTask task : this.postCloneTasks) {
                            task.execute(git.getRepository(), (IProgressMonitor)monitor);
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (repository != null) {
                        repository.close();
                    }
                    FileUtils.delete((File)this.workdir, (int)1);
                }
                catch (IOException ioe) {
                    throw new InvocationTargetException(e, NLS.bind((String)CoreText.CloneOperation_failed_cleanup, (Object)ioe.getLocalizedMessage()));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            if (repository != null) {
                repository.close();
            }
        }
    }

    public File getGitDir() {
        return this.gitdir;
    }

    public synchronized void addPostCloneTask(PostCloneTask task) {
        if (this.postCloneTasks == null) {
            this.postCloneTasks = new ArrayList<PostCloneTask>();
        }
        this.postCloneTasks.add(task);
    }

    public static interface PostCloneTask {
        public void execute(Repository var1, IProgressMonitor var2) throws CoreException;
    }
}

