/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreOperation
implements IEGitOperation {
    private final Collection<IPath> paths;
    private boolean gitignoreOutsideWSChanged;
    private ISchedulingRule schedulingRule;

    public IgnoreOperation(Collection<IPath> paths) {
        this.paths = paths;
        this.gitignoreOutsideWSChanged = false;
        this.schedulingRule = this.calcSchedulingRule();
    }

    @Deprecated
    public IgnoreOperation(IResource[] resources) {
        this.paths = new ArrayList<IPath>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IPath location = resource.getLocation();
            if (location != null) {
                this.paths.add(location);
            }
            ++n2;
        }
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreText.IgnoreOperation_taskName, this.paths.size());
        try {
            for (IPath path : this.paths) {
                if (monitor.isCanceled()) break;
                if (!RepositoryUtil.isIgnored(path)) {
                    this.addIgnore(monitor, path);
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(CoreText.IgnoreOperation_error, e));
        }
    }

    public boolean isGitignoreOutsideWSChanged() {
        return this.gitignoreOutsideWSChanged;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private void addIgnore(IProgressMonitor monitor, IPath path) throws UnsupportedEncodingException, CoreException, IOException {
        IPath parent = path.removeLastSegments(1);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation(parent);
        String entry = "/" + path.lastSegment() + "\n";
        if (container == null || container instanceof IWorkspaceRoot) {
            Repository repository = RepositoryMapping.getMapping(path).getRepository();
            IPath gitIgnorePath = parent.append(".gitignore");
            Path repoPath = new Path(repository.getWorkTree().getAbsolutePath());
            if (!repoPath.isPrefixOf(gitIgnorePath)) {
                String message = NLS.bind((String)CoreText.IgnoreOperation_parentOutsideRepo, (Object)path.toOSString(), (Object)repoPath.toOSString());
                IStatus status = Activator.error(message, null);
                throw new CoreException(status);
            }
            File gitIgnore = new File(gitIgnorePath.toOSString());
            this.updateGitIgnore(gitIgnore, entry);
            this.gitignoreOutsideWSChanged = true;
        } else {
            IFile gitignore = container.getFile((IPath)new Path(".gitignore"));
            entry = this.getEntry(gitignore.getLocation().toFile(), entry);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            ByteArrayInputStream entryBytes = this.asStream(entry);
            if (gitignore.exists()) {
                gitignore.appendContents((InputStream)entryBytes, true, true, (IProgressMonitor)subMonitor);
            } else {
                gitignore.create((InputStream)entryBytes, true, (IProgressMonitor)subMonitor);
            }
        }
    }

    private boolean prependNewline(File file) throws IOException {
        boolean prepend = false;
        long length = file.length();
        if (length > 0L) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                FileChannel channel = raf.getChannel();
                channel.position(length - 1L);
                if (channel.read(buffer) > 0) {
                    buffer.rewind();
                    prepend = buffer.get() != 10;
                }
            }
            finally {
                raf.close();
            }
        }
        return prepend;
    }

    private String getEntry(File file, String entry) throws IOException {
        return this.prependNewline(file) ? "\n" + entry : entry;
    }

    private void updateGitIgnore(File gitIgnore, String entry) throws CoreException {
        try {
            String ignoreLine = entry;
            if (!gitIgnore.exists()) {
                if (!gitIgnore.createNewFile()) {
                    String error = NLS.bind((String)CoreText.IgnoreOperation_creatingFailed, (Object)gitIgnore.getAbsolutePath());
                    throw new CoreException(Activator.error(error, null));
                }
                ignoreLine = this.getEntry(gitIgnore, ignoreLine);
            }
            FileOutputStream os = new FileOutputStream(gitIgnore, true);
            try {
                os.write(ignoreLine.getBytes());
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            String error = NLS.bind((String)CoreText.IgnoreOperation_updatingFailed, (Object)gitIgnore.getAbsolutePath());
            throw new CoreException(Activator.error(error, e));
        }
    }

    private ByteArrayInputStream asStream(String entry) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(entry.getBytes("UTF-8"));
    }

    private ISchedulingRule calcSchedulingRule() {
        return RuleUtil.getRuleForContainers(this.paths);
    }
}

