/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class MergeOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private MergeStrategy mergeStrategy;
    private boolean squash;
    private MergeResult mergeResult;

    public MergeOperation(Repository repository, String refName) {
        this.repository = repository;
        this.refName = refName;
    }

    public MergeOperation(Repository repository, String refName, String mergeStrategy) {
        this.repository = repository;
        this.refName = refName;
        if (mergeStrategy != null) {
            this.mergeStrategy = MergeStrategy.get((String)mergeStrategy);
        }
    }

    public void setSquash(boolean squash) {
        this.squash = squash;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        if (this.mergeResult != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor mymonitor) throws CoreException {
                MergeCommand merge;
                IProject[] validProjects = ProjectUtil.getValidOpenProjects(MergeOperation.this.repository);
                mymonitor.beginTask(NLS.bind((String)CoreText.MergeOperation_ProgressMerge, (Object)MergeOperation.this.refName), 3);
                Git git = new Git(MergeOperation.this.repository);
                mymonitor.worked(1);
                try {
                    MergeCommand.FastForwardMode ffmode = MergeOperation.this.getFastForwardMode();
                    Ref ref = MergeOperation.this.repository.getRef(MergeOperation.this.refName);
                    merge = ref != null ? git.merge().include(ref).setFastForward(ffmode) : git.merge().include((AnyObjectId)ObjectId.fromString((String)MergeOperation.this.refName)).setFastForward(ffmode);
                }
                catch (IOException e) {
                    throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
                }
                merge.setSquash(MergeOperation.this.squash);
                if (MergeOperation.this.mergeStrategy != null) {
                    merge.setStrategy(MergeOperation.this.mergeStrategy);
                }
                try {
                    try {
                        MergeOperation.this.mergeResult = merge.call();
                        mymonitor.worked(1);
                        if (MergeResult.MergeStatus.NOT_SUPPORTED.equals((Object)MergeOperation.this.mergeResult.getMergeStatus())) {
                            throw new TeamException((IStatus)new Status(1, Activator.getPluginId(), MergeOperation.this.mergeResult.toString()));
                        }
                    }
                    catch (NoHeadException e) {
                        throw new TeamException(CoreText.MergeOperation_MergeFailedNoHead, (Throwable)e);
                    }
                    catch (ConcurrentRefUpdateException e) {
                        throw new TeamException(CoreText.MergeOperation_MergeFailedRefUpdate, (Throwable)e);
                    }
                    catch (CheckoutConflictException e) {
                        MergeOperation.this.mergeResult = new MergeResult(e.getConflictingPaths());
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(mymonitor, 1));
                        mymonitor.done();
                        return;
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(mymonitor, 1));
                    mymonitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    private MergeCommand.FastForwardMode getFastForwardMode() throws IOException {
        MergeCommand.FastForwardMode ffmode = MergeCommand.FastForwardMode.valueOf((MergeCommand.FastForwardMode.Merge)((MergeCommand.FastForwardMode.Merge)this.repository.getConfig().getEnum("merge", null, "ff", (Enum)MergeCommand.FastForwardMode.Merge.TRUE)));
        ffmode = (MergeCommand.FastForwardMode)this.repository.getConfig().getEnum("branch", this.repository.getBranch(), "mergeoptions", (Enum)ffmode);
        return ffmode;
    }

    public MergeResult getResult() {
        return this.mergeResult;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

