/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.egit.github.core.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubRequest {
    private String uri;
    private Map<String, String> params;
    private Type type;
    private String responseContentType;

    public String getUri() {
        return this.uri;
    }

    protected void addParams(StringBuilder uri) {
        UrlUtils.addParams(this.getParams(), uri);
    }

    public String generateUri() {
        String baseUri = this.uri;
        if (baseUri == null) {
            return null;
        }
        if (baseUri.indexOf(63) != -1) {
            return baseUri;
        }
        StringBuilder params = new StringBuilder();
        this.addParams(params);
        if (params.length() > 0) {
            return String.valueOf(baseUri) + '?' + params;
        }
        return baseUri;
    }

    public GitHubRequest setUri(StringBuilder uri) {
        return this.setUri(uri != null ? uri.toString() : null);
    }

    public GitHubRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public GitHubRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public GitHubRequest setType(Type type) {
        this.type = type;
        return this;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public GitHubRequest setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
        return this;
    }

    public int hashCode() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GitHubRequest)) {
            return false;
        }
        String fullUri = this.generateUri();
        String objUri = ((GitHubRequest)obj).generateUri();
        return fullUri != null && objUri != null && fullUri.equals(objUri);
    }

    public String toString() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri : super.toString();
    }
}

