/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1 && resources[0] instanceof IFile) {
            IFile baseFile = (IFile)resources[0];
            String gitPath = RepositoryMapping.getMapping((IResource)baseFile.getProject()).getRepoRelativePath((IResource)baseFile);
            ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
            ITypedElement next = CompareUtils.getHeadTypedElement(repository, gitPath);
            if (next == null) {
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
            CompareUI.openCompareEditor((CompareEditorInput)in);
            return null;
        }
        try {
            CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
            try {
                Ref head = repository.getRef("HEAD");
                if (head == null || head.getObjectId() == null) {
                    Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                    MessageDialog.openInformation((Shell)shell, (String)UIText.CompareWithHeadActionHandler_NoHeadTitle, (String)UIText.CompareWithHeadActionHandler_NoHeadMessage);
                } else {
                    view.setInput(resources, Repository.shortenRefName((String)head.getTarget().getName()));
                }
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                return null;
            }
        }
        catch (PartInitException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

