/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTargetSelectionDialog;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareWithRefActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(true, event);
        if (repo == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        CompareTargetSelectionDialog dlg = new CompareTargetSelectionDialog(this.getShell(event), repo, resources.length == 1 ? resources[0].getFullPath().lastSegment() : null);
        if (dlg.open() == 0) {
            if (resources.length == 1 && resources[0] instanceof IFile) {
                IFile baseFile = (IFile)resources[0];
                if (CompareUtils.canDirectlyOpenInCompare(baseFile)) {
                    this.showSingleFileComparison(baseFile, dlg.getRefName());
                } else {
                    this.synchronizeModel(baseFile, repo, dlg.getRefName());
                }
            } else {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    view.setInput(resources, dlg.getRefName());
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        }
        return null;
    }

    private void showSingleFileComparison(IFile file, String refName) {
        ITypedElement next;
        ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)file);
        try {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            next = this.getElementForRef(mapping.getRepository(), mapping.getRepoRelativePath((IResource)file), refName);
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
            return;
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        in.getCompareConfiguration().setRightLabel(refName);
        CompareUI.openCompareEditor((CompareEditorInput)in);
    }

    private void synchronizeModel(IFile file, Repository repo, String refName) {
        try {
            GitModelSynchronize.synchronizeModelWithWorkspace(file, repo, refName);
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
            return;
        }
    }

    private ITypedElement getElementForRef(Repository repository, String gitPath, String refName) throws IOException {
        ObjectId commitId = repository.resolve(String.valueOf(refName) + "^{commit}");
        RevWalk rw = new RevWalk(repository);
        RevCommit commit = rw.parseCommit((AnyObjectId)commitId);
        rw.release();
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, repository);
    }

    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

