/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowBlameActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] selected = this.getSelectedResources();
        if (selected.length != 1 || !(selected[0] instanceof IStorage)) {
            return null;
        }
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)selected[0].getProject());
        if (mapping == null) {
            return null;
        }
        String path = mapping.getRepoRelativePath(selected[0]);
        IStorage storage = (IStorage)selected[0];
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPage page = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage();
        JobUtil.scheduleUserJob((IEGitOperation)new BlameOperation(repository, storage, path, null, shell, page), (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
        return null;
    }

    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        return selectedResources.length == 1 && this.selectionMapsToSingleRepository();
    }
}

