/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesDialog;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesTree;
import org.eclipse.egit.ui.internal.stash.StashCreateUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BranchResultDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final CheckoutResult result;
    private final Repository repository;
    private static String target;

    public static void show(final CheckoutResult result, final Repository repository, final String target) {
        BranchResultDialog.target = target;
        if (result.getStatus() == CheckoutResult.Status.CONFLICTS) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new BranchResultDialog(shell, repository, result, target, null).open();
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.NONDELETED) {
            boolean show = false;
            List pathList = result.getUndeletedList();
            for (String path : pathList) {
                if (!new File(repository.getWorkTree(), path).exists()) continue;
                show = true;
                break;
            }
            if (!show) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new NonDeletedFilesDialog(shell, repository, result.getUndeletedList()).open();
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.OK) {
            try {
                if (ObjectId.isId((String)repository.getFullBranch())) {
                    BranchResultDialog.showDetachedHeadWarning();
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
    }

    private BranchResultDialog(Shell shell, Repository repository, CheckoutResult result, String target) {
        super(shell, UIText.BranchResultDialog_CheckoutConflictsTitle, INFO, NLS.bind((String)UIText.BranchResultDialog_CheckoutConflictsMessage, (Object)Repository.shortenRefName((String)target)), 2, new String[0], -1);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.result = result;
    }

    protected Control createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        new NonDeletedFilesTree(main, this.repository, this.result.getConflictList());
        BranchResultDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        boolean shouldCheckout = false;
        switch (buttonId) {
            case 10: {
                CommitUI commitUI = new CommitUI(this.getShell(), this.repository, new IResource[0], true);
                shouldCheckout = commitUI.commit();
                break;
            }
            case 7: {
                ResetOperation operation = new ResetOperation(this.repository, "HEAD", ResetCommand.ResetType.HARD);
                String jobname = NLS.bind((String)UIText.ResetAction_reset, (Object)"HEAD");
                JobUtil.scheduleUserJob((IEGitOperation)operation, (String)jobname, (Object)JobFamilies.RESET);
                shouldCheckout = true;
                break;
            }
            case 5: {
                StashCreateUI stashCreateUI = new StashCreateUI(this.getShell(), this.repository);
                shouldCheckout = stashCreateUI.createStash();
                break;
            }
            case 1: {
                super.buttonPressed(buttonId);
                return;
            }
        }
        if (shouldCheckout) {
            super.buttonPressed(buttonId);
            BranchOperationUI op = BranchOperationUI.checkout(this.repository, target);
            op.start();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 10, UIText.BranchResultDialog_buttonCommit, false);
        this.createButton(parent, 5, UIText.BranchResultDialog_buttonStash, false);
        this.createButton(parent, 7, UIText.BranchResultDialog_buttonReset, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    private static void showDetachedHeadWarning() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store.getBoolean("show_detached_head_warning")) {
                    String toggleMessage = UIText.BranchResultDialog_dontShowAgain;
                    MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.BranchOperationUI_DetachedHeadTitle, (String)UIText.BranchOperationUI_DetachedHeadMessage, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"show_detached_head_warning");
                }
            }
        });
    }

    /* synthetic */ BranchResultDialog(Shell shell, Repository repository, CheckoutResult checkoutResult, String string, BranchResultDialog branchResultDialog) {
        this(shell, repository, checkoutResult, string);
    }
}

