/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clean;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanRepositoryPage
extends WizardPage {
    private Repository repository;
    private CheckboxTableViewer cleanTable;
    private boolean cleanDirectories;
    private boolean includeIgnored;

    public CleanRepositoryPage(Repository repository) {
        super(UIText.CleanRepositoryPage_title);
        this.repository = repository;
        this.setTitle(UIText.CleanRepositoryPage_title);
        this.setMessage(UIText.CleanRepositoryPage_message);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout());
        Button radioCleanFiles = new Button(main, 16);
        radioCleanFiles.setText(UIText.CleanRepositoryPage_cleanFiles);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)radioCleanFiles);
        final Button radioCleanDirs = new Button(main, 16);
        radioCleanDirs.setText(UIText.CleanRepositoryPage_cleanDirs);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)radioCleanDirs);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanRepositoryPage.this.cleanDirectories = radioCleanDirs.getSelection();
                CleanRepositoryPage.this.updateCleanItems();
            }
        };
        radioCleanFiles.addSelectionListener((SelectionListener)listener);
        radioCleanDirs.addSelectionListener((SelectionListener)listener);
        radioCleanFiles.setSelection(true);
        final Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        final Image dirImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.cleanTable = CheckboxTableViewer.newCheckList((Composite)main, (int)2048);
        this.cleanTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cleanTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (!(element instanceof String)) {
                    return null;
                }
                if (((String)element).endsWith("/")) {
                    return dirImage;
                }
                return fileImage;
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.cleanTable.getControl());
        Composite lowerComp = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)lowerComp);
        lowerComp.setLayout((Layout)new GridLayout(3, false));
        final Button checkIncludeIgnored = new Button(lowerComp, 32);
        checkIncludeIgnored.setText(UIText.CleanRepositoryPage_includeIgnored);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)checkIncludeIgnored);
        checkIncludeIgnored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanRepositoryPage.this.includeIgnored = checkIncludeIgnored.getSelection();
                CleanRepositoryPage.this.updateCleanItems();
            }
        });
        Button selAll = new Button(lowerComp, 8);
        selAll.setText(UIText.WizardProjectsImportPage_selectAll);
        GridDataFactory.defaultsFor((Control)selAll).applyTo((Control)selAll);
        Button selNone = new Button(lowerComp, 8);
        selNone.setText(UIText.WizardProjectsImportPage_deselectAll);
        GridDataFactory.defaultsFor((Control)selNone).applyTo((Control)selNone);
        selAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CleanRepositoryPage.this.cleanTable.getInput() instanceof Set) {
                    Set input = (Set)CleanRepositoryPage.this.cleanTable.getInput();
                    CleanRepositoryPage.this.cleanTable.setCheckedElements(input.toArray());
                }
            }
        });
        selNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanRepositoryPage.this.cleanTable.setCheckedElements(new Object[0]);
            }
        });
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CleanRepositoryPage.this.updateCleanItems();
                }
            });
        }
    }

    private void updateCleanItems() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(UIText.CleanRepositoryPage_findingItems, -1);
                    Git git = Git.wrap((Repository)CleanRepositoryPage.this.repository);
                    CleanCommand command = git.clean().setDryRun(true);
                    command.setCleanDirectories(CleanRepositoryPage.this.cleanDirectories);
                    command.setIgnore(!CleanRepositoryPage.this.includeIgnored);
                    try {
                        final Set paths = command.call();
                        CleanRepositoryPage.this.getShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                CleanRepositoryPage.this.cleanTable.setInput((Object)paths);
                            }
                        });
                    }
                    catch (GitAPIException ex) {
                        Activator.logError("cannot call clean command!", ex);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.logError("Unexpected exception while finding items to clean", e);
            this.clearPage();
        }
        catch (InterruptedException interruptedException) {
            this.clearPage();
        }
    }

    private void clearPage() {
        this.cleanTable.setInput(null);
    }

    public Set<String> getItemsToClean() {
        TreeSet<String> result = new TreeSet<String>();
        Object[] objectArray = this.cleanTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object ele = objectArray[n2];
            String str = ele.toString();
            if (str.endsWith("/")) {
                result.add(str.substring(0, str.length() - 1));
            } else {
                result.add(str);
            }
            ++n2;
        }
        return result;
    }

    public void finish() {
        try {
            final Set<String> itemsToClean = this.getItemsToClean();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(UIText.CleanRepositoryPage_cleaningItems, -1);
                    Git git = Git.wrap((Repository)CleanRepositoryPage.this.repository);
                    CleanCommand command = git.clean().setDryRun(false);
                    command.setCleanDirectories(CleanRepositoryPage.this.cleanDirectories);
                    command.setIgnore(!CleanRepositoryPage.this.includeIgnored);
                    command.setPaths(itemsToClean);
                    try {
                        command.call();
                    }
                    catch (GitAPIException ex) {
                        Activator.logError("cannot call clean command!", ex);
                    }
                    try {
                        IProject[] projects = ProjectUtil.getProjectsContaining((Repository)CleanRepositoryPage.this.repository, (Collection)itemsToClean);
                        ProjectUtil.refreshResources((IResource[])projects, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException coreException) {}
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            Activator.logError("Unexpected exception while cleaning", e);
        }
    }
}

