/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class DiffStyleRangeFormatter
extends DiffFormatter {
    private DocumentOutputStream stream;
    private List<DiffStyleRange> ranges = new ArrayList<DiffStyleRange>();

    public DiffStyleRangeFormatter(IDocument document, int offset) {
        super((OutputStream)new DocumentOutputStream(document, offset));
        this.stream = (DocumentOutputStream)this.getOutputStream();
    }

    public DiffStyleRangeFormatter(IDocument document) {
        this(document, document.getLength());
    }

    public DiffStyleRangeFormatter write(Repository repository, FileDiff diff) throws IOException {
        this.stream.charset = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)diff.getPath());
        diff.outputDiff(null, repository, this, true);
        this.flush();
        return this;
    }

    public DiffStyleRange[] getRanges() {
        return this.ranges.toArray(new DiffStyleRange[this.ranges.size()]);
    }

    protected DiffStyleRange addRange(DiffStyleRange.Type type, int start, int end) {
        DiffStyleRange range = new DiffStyleRange();
        range.start = start;
        range.diffType = type;
        range.length = end - start;
        this.ranges.add(range);
        return range;
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        int start = this.stream.offset;
        super.writeHunkHeader(aStartLine, aEndLine, bStartLine, bEndLine);
        this.stream.flushLine();
        this.addRange(DiffStyleRange.Type.HUNK, start, this.stream.offset);
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        if (prefix == ' ') {
            super.writeLine(prefix, text, cur);
            this.stream.flushLine();
        } else {
            DiffStyleRange.Type type = prefix == '+' ? DiffStyleRange.Type.ADD : DiffStyleRange.Type.REMOVE;
            int start = this.stream.offset;
            super.writeLine(prefix, text, cur);
            this.stream.flushLine();
            this.addRange(type, start, this.stream.offset);
        }
    }

    protected void formatGitDiffFirstHeaderLine(ByteArrayOutputStream o, DiffEntry.ChangeType type, String oldPath, String newPath) throws IOException {
        this.stream.flushLine();
        int offset = this.stream.offset;
        int start = o.size();
        super.formatGitDiffFirstHeaderLine(o, type, oldPath, newPath);
        int end = o.size();
        this.addRange(DiffStyleRange.Type.HEADLINE, offset + start, offset + end);
    }

    public void format(EditList edits, RawText a, RawText b) throws IOException {
        this.stream.flushLine();
        super.format(edits, a, b);
    }

    public static class DiffStyleRange
    extends StyleRange {
        public Type diffType = Type.OTHER;
        public Color lineBackground = null;

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean similarTo(StyleRange style) {
            return super.similarTo(style) && style instanceof DiffStyleRange && this.diffType == ((DiffStyleRange)style).diffType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ADD,
            REMOVE,
            HUNK,
            HEADLINE,
            OTHER;

        }
    }

    private static class DocumentOutputStream
    extends OutputStream {
        private String charset;
        private IDocument document;
        private int offset;
        private StringBuilder lineBuffer = new StringBuilder();

        public DocumentOutputStream(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        private void write(String content) throws IOException {
            try {
                this.document.replace(this.offset, 0, content);
                this.offset += content.length();
            }
            catch (BadLocationException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.charset == null) {
                this.lineBuffer.append(new String(b, off, len));
            } else {
                this.lineBuffer.append(new String(b, off, len, this.charset));
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        protected void flushLine() throws IOException {
            if (this.lineBuffer.length() > 0) {
                this.write(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }
}

