/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.ICommitMessageProvider;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitMessageComponent {
    private static final String EMPTY_STRING = "";
    private static final String COMMIT_MESSAGE_PROVIDER_ID = "org.eclipse.egit.ui.commitMessageProvider";
    private static final String COMMITTER_VALUES_PREF = "CommitDialog.committerValues";
    private static final String AUTHOR_VALUES_PREF = "CommitDialog.authorValues";
    ICommitMessageComponentNotifications listener;
    SpellcheckableMessageArea commitText;
    Text authorText;
    Text committerText;
    ObjectId originalChangeId;
    private String commitMessage = null;
    private String commitMessageBeforeAmending = "";
    private String previousCommitMessage = "";
    private String author = null;
    private String previousAuthor = null;
    private String committer = null;
    private boolean signedOff = false;
    private boolean amending = false;
    private boolean commitAllowed = true;
    private String cannotCommitMessage = null;
    private boolean amendAllowed = false;
    private boolean amendingCommitInRemoteBranch = false;
    private boolean createChangeId = false;
    private UIUtils.IPreviousValueProposalHandler authorHandler;
    private UIUtils.IPreviousValueProposalHandler committerHandler;
    private Repository repository;
    private Collection<String> filesToCommit = new ArrayList<String>();
    private ObjectId headCommitId;
    private boolean listersEnabled;

    public CommitMessageComponent(Repository repository, ICommitMessageComponentNotifications listener) {
        this.repository = repository;
        this.listener = listener;
    }

    public CommitMessageComponent(ICommitMessageComponentNotifications listener) {
        this.listener = listener;
    }

    public void resetState() {
        this.originalChangeId = null;
        this.commitMessage = null;
        this.commitMessageBeforeAmending = EMPTY_STRING;
        this.previousCommitMessage = EMPTY_STRING;
        this.author = null;
        this.previousAuthor = null;
        this.committer = null;
        this.signedOff = false;
        this.amending = false;
        this.amendAllowed = false;
        this.createChangeId = false;
        this.filesToCommit = new ArrayList<String>();
        this.headCommitId = null;
        this.listersEnabled = false;
    }

    public String getCommitMessage() {
        this.commitMessage = this.commitText.getCommitMessage();
        return this.commitMessage;
    }

    public void setCommitMessage(String s) {
        this.commitMessage = s;
    }

    public String getAuthor() {
        this.author = this.authorText.getText().trim();
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setSignedOff(boolean signedOff) {
        this.signedOff = signedOff;
    }

    public void setCreateChangeId(boolean createChangeId) {
        this.createChangeId = createChangeId;
    }

    public String getCommitter() {
        this.committer = this.committerText.getText().trim();
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public void setFilesToCommit(Collection<String> filesToCommit) {
        this.filesToCommit = filesToCommit;
    }

    public boolean isSignedOff() {
        return this.signedOff;
    }

    public boolean isAmending() {
        return this.amending;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setCommitAllowed(boolean commitAllowed) {
        this.commitAllowed = commitAllowed;
    }

    public void setCannotCommitMessage(String cannotCommitMessage) {
        this.cannotCommitMessage = cannotCommitMessage;
    }

    public void setAmendAllowed(boolean amendAllowed) {
        this.amendAllowed = amendAllowed;
        this.commitMessageBeforeAmending = EMPTY_STRING;
    }

    public void setAmendingButtonSelection(boolean selection) {
        this.amending = selection;
        if (!selection) {
            this.originalChangeId = null;
            this.authorText.setText(this.author);
            this.commitText.setText(this.commitMessageBeforeAmending);
            this.commitMessageBeforeAmending = EMPTY_STRING;
        } else {
            this.getHeadCommitInfo();
            this.saveOriginalChangeId();
            this.commitMessageBeforeAmending = this.commitText.getText();
            this.commitText.setText(this.previousCommitMessage);
            if (this.previousAuthor != null) {
                this.authorText.setText(this.previousAuthor);
            }
        }
        this.refreshChangeIdText();
    }

    public boolean getCreateChangeId() {
        return this.createChangeId;
    }

    public void updateStateFromUI() {
        this.commitMessage = this.commitText.getText();
        this.author = this.authorText.getText().trim();
        this.committer = this.committerText.getText().trim();
    }

    public void updateUIFromState() {
        this.commitText.setText(this.commitMessage);
        this.authorText.setText(this.author);
        this.committerText.setText(this.committer);
    }

    public CommitMessageComponentState getState() {
        this.updateStateFromUI();
        CommitMessageComponentState state = new CommitMessageComponentState();
        state.setAmend(this.isAmending());
        state.setAuthor(this.getAuthor());
        state.setCommitMessage(this.commitText.getText());
        state.setCommitter(this.getCommitter());
        state.setHeadCommit(this.getHeadCommit());
        return state;
    }

    public void enableListers(boolean enable) {
        this.listersEnabled = enable;
    }

    public CommitStatus getStatus() {
        if (!this.commitAllowed) {
            return new CommitStatus(this.cannotCommitMessage, 3);
        }
        String authorValue = this.authorText.getText();
        if (authorValue.length() == 0 || RawParseUtils.parsePersonIdent((String)authorValue) == null) {
            return new CommitStatus(UIText.CommitMessageComponent_MessageInvalidAuthor, 3);
        }
        String committerValue = this.committerText.getText();
        if (committerValue.length() == 0 || RawParseUtils.parsePersonIdent((String)committerValue) == null) {
            return new CommitStatus(UIText.CommitMessageComponent_MessageInvalidCommitter, 3);
        }
        if (this.amending && this.amendingCommitInRemoteBranch) {
            return new CommitStatus(UIText.CommitMessageComponent_AmendingCommitInRemoteBranch, 2);
        }
        return CommitStatus.OK;
    }

    public boolean checkCommitInfo() {
        this.updateStateFromUI();
        if (this.commitMessage.trim().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoMessage, (String)UIText.CommitDialog_ErrorMustEnterCommitMessage);
            return false;
        }
        boolean authorValid = false;
        if (this.author.length() > 0) {
            boolean bl = authorValid = RawParseUtils.parsePersonIdent((String)this.author) != null;
        }
        if (!authorValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidAuthorSpecified);
            return false;
        }
        boolean committerValid = false;
        if (this.committer.length() > 0) {
            boolean bl = committerValid = RawParseUtils.parsePersonIdent((String)this.committer) != null;
        }
        if (!committerValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidCommitterSpecified);
            return false;
        }
        this.authorHandler.updateProposals();
        this.committerHandler.updateProposals();
        return true;
    }

    public void attachControls(SpellcheckableMessageArea commitText, Text authorText, Text committerText) {
        this.commitText = commitText;
        this.authorText = authorText;
        this.committerText = committerText;
        this.addListeners();
    }

    private void addListeners() {
        this.authorHandler = UIUtils.addPreviousValuesContentProposalToText(this.authorText, AUTHOR_VALUES_PREF);
        this.committerText.addModifyListener(new ModifyListener(){
            String oldCommitter;
            {
                this.oldCommitter = CommitMessageComponent.this.committerText.getText();
            }

            public void modifyText(ModifyEvent e) {
                if (!CommitMessageComponent.this.listersEnabled) {
                    return;
                }
                if (CommitMessageComponent.this.signedOff) {
                    String newCommitter = CommitMessageComponent.this.committerText.getText();
                    String oldSignOff = CommitMessageComponent.this.getSignedOff(this.oldCommitter);
                    String newSignOff = CommitMessageComponent.this.getSignedOff(newCommitter);
                    CommitMessageComponent.this.commitText.setText(CommitMessageComponent.this.replaceSignOff(CommitMessageComponent.this.commitText.getText(), oldSignOff, newSignOff));
                    this.oldCommitter = newCommitter;
                }
            }
        });
        this.committerHandler = UIUtils.addPreviousValuesContentProposalToText(this.committerText, COMMITTER_VALUES_PREF);
        this.commitText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CommitMessageComponent.this.listersEnabled) {
                    return;
                }
                CommitMessageComponent.this.updateSignedOffButton();
                CommitMessageComponent.this.updateChangeIdButton();
            }
        });
    }

    public void setDefaults() {
        this.createChangeId = this.repository.getConfig().getBoolean("gerrit", "createchangeid", false);
        this.signedOff = Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by");
    }

    public void updateUI() {
        String calculatedCommitMessage;
        if (this.amending) {
            this.getHeadCommitInfo();
        }
        boolean calculatedMessageHasChangeId = this.findOffsetOfChangeIdLine(calculatedCommitMessage = this.calculateCommitMessage(this.filesToCommit)) > 0;
        this.commitText.setText(calculatedCommitMessage);
        this.authorText.setText(this.getSafeString(this.author));
        this.committerText.setText(this.getSafeString(this.committer));
        if (this.amending) {
            this.authorText.setText(this.previousAuthor);
            this.saveOriginalChangeId();
        } else {
            if (!this.amendAllowed) {
                this.originalChangeId = null;
            }
            this.refreshSignedOffBy();
            if (!calculatedMessageHasChangeId) {
                this.refreshChangeIdText();
            }
        }
        this.updateSignedOffButton();
        this.updateChangeIdButton();
    }

    public void updateSignedOffAndChangeIdButton() {
        this.updateSignedOffButton();
        this.updateChangeIdButton();
    }

    private void getHeadCommitInfo() {
        CommitHelper.CommitInfo headCommitInfo = CommitHelper.getHeadCommitInfo(this.repository);
        RevCommit previousCommit = headCommitInfo.getCommit();
        this.amendingCommitInRemoteBranch = this.isContainedInAnyRemoteBranch(previousCommit);
        this.previousCommitMessage = headCommitInfo.getCommitMessage();
        this.previousAuthor = headCommitInfo.getAuthor();
    }

    private boolean isContainedInAnyRemoteBranch(RevCommit commit) {
        try {
            Collection refs = this.repository.getRefDatabase().getRefs("refs/remotes/").values();
            return RevUtils.isContainedInAnyRef((Repository)this.repository, (ObjectId)commit, refs);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String getSafeString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private String calculateCommitMessage(Collection<String> paths) {
        if (this.commitMessage != null) {
            return this.commitMessage;
        }
        if (this.amending) {
            return this.previousCommitMessage;
        }
        String calculatedCommitMessage = null;
        HashSet<IProject> resources = new HashSet<IProject>();
        for (String path : paths) {
            IFile file = this.findFile(path);
            if (file == null) continue;
            resources.add(file.getProject());
        }
        try {
            ICommitMessageProvider messageProvider = this.getCommitMessageProvider();
            if (messageProvider != null) {
                IResource[] resourcesArray = resources.toArray(new IResource[0]);
                calculatedCommitMessage = messageProvider.getMessage(resourcesArray);
            }
        }
        catch (CoreException coreException) {
            org.eclipse.egit.core.Activator.error((String)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        if (calculatedCommitMessage != null) {
            return calculatedCommitMessage;
        }
        return EMPTY_STRING;
    }

    private ICommitMessageProvider getCommitMessageProvider() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(COMMIT_MESSAGE_PROVIDER_ID);
        if (config.length > 0) {
            Object provider = config[0].createExecutableExtension("class");
            if (provider instanceof ICommitMessageProvider) {
                return (ICommitMessageProvider)provider;
            }
            org.eclipse.egit.core.Activator.logError((String)UIText.CommitDialog_WrongTypeOfCommitMessageProvider, null);
        }
        return null;
    }

    private void saveOriginalChangeId() {
        int changeIdOffset = this.findOffsetOfChangeIdLine(this.previousCommitMessage);
        if (changeIdOffset > 0) {
            int endOfChangeId = this.findNextEOL(changeIdOffset, this.previousCommitMessage);
            if (endOfChangeId < 0) {
                endOfChangeId = this.previousCommitMessage.length();
            }
            int sha1Offset = changeIdOffset + "Change-Id: I".length();
            try {
                this.originalChangeId = ObjectId.fromString((String)this.previousCommitMessage.substring(sha1Offset, endOfChangeId));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.originalChangeId = null;
            }
        } else {
            this.originalChangeId = null;
        }
    }

    private int findNextEOL(int oldPos, String message) {
        return message.indexOf(Text.DELIMITER, oldPos + 1);
    }

    private int findOffsetOfChangeIdLine(String message) {
        return ChangeIdUtil.indexOfChangeId((String)message, (String)Text.DELIMITER);
    }

    private void updateChangeIdButton() {
        String curText = this.commitText.getText();
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        this.createChangeId = curText.indexOf(String.valueOf(Text.DELIMITER) + "Change-Id: ") != -1;
        this.listener.updateChangeIdToggleSelection(this.createChangeId);
    }

    private void refreshChangeIdText() {
        if (this.createChangeId) {
            String changedText;
            String text = this.commitText.getText().replaceAll(Text.DELIMITER, "\n");
            if (!text.equals(changedText = ChangeIdUtil.insertId((String)text, (ObjectId)(this.originalChangeId != null ? this.originalChangeId : ObjectId.zeroId()), (boolean)true))) {
                changedText = changedText.replaceAll("\n", Text.DELIMITER);
                this.commitText.setText(changedText);
            }
        } else {
            String text = this.commitText.getText();
            int changeIdOffset = this.findOffsetOfChangeIdLine(text);
            if (changeIdOffset > 0) {
                int endOfChangeId = this.findNextEOL(changeIdOffset, text);
                String cleanedText = endOfChangeId == -1 ? text.substring(0, changeIdOffset) : String.valueOf(text.substring(0, changeIdOffset)) + text.substring(endOfChangeId + 1);
                this.commitText.setText(cleanedText);
            }
        }
    }

    private String getSignedOff() {
        return this.getSignedOff(this.committerText.getText());
    }

    private String getSignedOff(String signer) {
        return "Signed-off-by: " + signer;
    }

    private String signOff(String input) {
        String output = input;
        if (!output.endsWith(Text.DELIMITER)) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        if (!this.getLastLine(output).matches("[A-Za-z\\-]+:.*")) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        output = String.valueOf(output) + this.getSignedOff();
        return output;
    }

    private String getLastLine(String input) {
        String output = input;
        int breakLength = Text.DELIMITER.length();
        int lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER);
        if (lastIndexOfLineBreak != -1 && lastIndexOfLineBreak == output.length() - breakLength) {
            output = output.substring(0, output.length() - breakLength);
        }
        return (lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER)) == -1 ? output : output.substring(lastIndexOfLineBreak + breakLength, output.length());
    }

    private void updateSignedOffButton() {
        String curText = this.commitText.getText();
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        this.signedOff = curText.indexOf(String.valueOf(this.getSignedOff()) + Text.DELIMITER) != -1;
        this.listener.updateSignedOffToggleSelection(this.signedOff);
    }

    private void refreshSignedOffBy() {
        String curText = this.commitText.getText();
        if (this.signedOff) {
            this.commitText.setText(this.signOff(curText));
        } else {
            String s = this.getSignedOff();
            if (s != null) {
                if ((curText = this.replaceSignOff(curText, s, EMPTY_STRING)).endsWith(String.valueOf(Text.DELIMITER) + Text.DELIMITER)) {
                    curText = curText.substring(0, curText.length() - Text.DELIMITER.length());
                }
                this.commitText.setText(curText);
            }
        }
    }

    private String replaceSignOff(String input, String oldSignOff, String newSignOff) {
        int indexOfSignOff;
        assert (input != null);
        assert (oldSignOff != null);
        assert (newSignOff != null);
        String curText = input;
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        if ((indexOfSignOff = curText.indexOf(String.valueOf(oldSignOff) + Text.DELIMITER)) == -1) {
            return input;
        }
        return String.valueOf(input.substring(0, indexOfSignOff)) + newSignOff + input.substring(indexOfSignOff + oldSignOff.length(), input.length());
    }

    private IFile findFile(String path) {
        URI uri = new File(this.repository.getWorkTree(), path).toURI();
        IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (workspaceFiles.length > 0) {
            return workspaceFiles[0];
        }
        return null;
    }

    public void setSignedOffButtonSelection(boolean signedOffButtonSelection) {
        this.signedOff = signedOffButtonSelection;
        this.refreshSignedOffBy();
    }

    public void setChangeIdButtonSelection(boolean selection) {
        this.createChangeId = selection;
        this.refreshChangeIdText();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setHeadCommit(ObjectId id) {
        this.headCommitId = id;
    }

    public ObjectId getHeadCommit() {
        return this.headCommitId;
    }

    public static class CommitStatus
    implements IMessageProvider {
        private static final CommitStatus OK = new CommitStatus();
        private final String message;
        private final int type;

        private CommitStatus() {
            this.message = null;
            this.type = 0;
        }

        private CommitStatus(String message, int type) {
            this.message = message;
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }
    }
}

