/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffContentProvider;
import org.eclipse.egit.ui.internal.history.FileDiffLabelProvider;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.themes.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitFileDiffViewer
extends TableViewer {
    private static final String LINESEP = System.getProperty("line.separator");
    private Repository db;
    private TreeWalk walker;
    private Clipboard clipboard;
    private IAction selectAll;
    private IAction copy;
    private IAction open;
    private IAction blame;
    private IAction openWorkingTreeVersion;
    private IAction compare;
    private IAction compareWorkingTreeVersion;
    private final IWorkbenchSite site;

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site) {
        this(parent, site, 68354);
    }

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site, int style) {
        super(parent, style);
        this.site = site;
        Table rawTable = this.getTable();
        rawTable.setLinesVisible(true);
        Color fg = rawTable.getForeground();
        Color bg = rawTable.getBackground();
        RGB dimmedForegroundRgb = ColorUtil.blend((RGB)fg.getRGB(), (RGB)bg.getRGB(), (int)60);
        this.setLabelProvider((IBaseLabelProvider)new FileDiffLabelProvider(dimmedForegroundRgb));
        this.setContentProvider((IContentProvider)new FileDiffContentProvider());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)((Object)iss.getFirstElement());
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    if (d.getBlobs().length <= 2) {
                        CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.CommitFileDiffViewer_CanNotOpenCompareEditorTitle, (String)UIText.CommitFileDiffViewer_MergeCommitMultiAncestorMessage);
                    }
                } else {
                    CommitFileDiffViewer.this.openFileInEditor(d);
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitFileDiffViewer.this.updateActionEnablement(event.getSelection());
            }
        });
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitFileDiffViewer.this.clipboard.dispose();
            }
        });
        MenuManager mgr = new MenuManager();
        Control c = this.getControl();
        c.setMenu(mgr.createContextMenu(c));
        this.open = new Action(UIText.CommitFileDiffViewer_OpenInEditorMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                Iterator it = iss.iterator();
                while (it.hasNext()) {
                    CommitFileDiffViewer.this.openFileInEditor((FileDiff)((Object)it.next()));
                }
            }
        };
        this.blame = new Action(UIText.CommitFileDiffViewer_ShowAnnotationsMenuLabel, UIIcons.ANNOTATE){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                Iterator it = iss.iterator();
                while (it.hasNext()) {
                    CommitFileDiffViewer.this.showAnnotations((FileDiff)((Object)it.next()));
                }
            }
        };
        this.openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                Iterator it = iss.iterator();
                while (it.hasNext()) {
                    String relativePath = ((FileDiff)((Object)it.next())).getPath();
                    String path = new Path(CommitFileDiffViewer.this.getRepository().getWorkTree().getAbsolutePath()).append(relativePath).toOSString();
                    CommitFileDiffViewer.this.openFileInEditor(path);
                }
            }
        };
        this.compare = new Action(UIText.CommitFileDiffViewer_CompareMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)((Object)iss.getFirstElement());
                if (d.getBlobs().length <= 2) {
                    CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.CommitFileDiffViewer_CanNotOpenCompareEditorTitle, (String)UIText.CommitFileDiffViewer_MergeCommitMultiAncestorMessage);
                }
            }
        };
        this.compareWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_CompareWorkingDirectoryMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                CommitFileDiffViewer.this.showWorkingDirectoryFileDiff((FileDiff)((Object)iss.getFirstElement()));
            }
        };
        mgr.add(this.openWorkingTreeVersion);
        mgr.add(this.open);
        mgr.add(this.compare);
        mgr.add(this.compareWorkingTreeVersion);
        mgr.add(this.blame);
        MenuManager showInSubMenu = UIUtils.createShowInMenu(site.getWorkbenchWindow());
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)showInSubMenu);
        mgr.add((IContributionItem)new Separator());
        this.selectAll = this.createStandardAction(ActionFactory.SELECT_ALL);
        mgr.add(this.selectAll);
        this.copy = this.createStandardAction(ActionFactory.COPY);
        mgr.add(this.copy);
        if (site instanceof IPageSite) {
            final IPageSite pageSite = (IPageSite)site;
            this.getControl().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    pageSite.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                    pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                    pageSite.getActionBars().updateActionBars();
                }

                public void focusGained(FocusEvent e) {
                    CommitFileDiffViewer.this.updateActionEnablement(CommitFileDiffViewer.this.getSelection());
                    pageSite.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), CommitFileDiffViewer.this.selectAll);
                    pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), CommitFileDiffViewer.this.copy);
                    pageSite.getActionBars().updateActionBars();
                }
            });
        }
    }

    private void updateActionEnablement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean allSelected = !sel.isEmpty() && sel.size() == this.getTable().getItemCount();
        boolean submoduleSelected = false;
        Object[] objectArray = sel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (((FileDiff)((Object)item)).isSubmodule()) {
                submoduleSelected = true;
                break;
            }
            ++n2;
        }
        this.selectAll.setEnabled(!allSelected);
        this.copy.setEnabled(!sel.isEmpty());
        if (!submoduleSelected) {
            boolean oneOrMoreSelected = !sel.isEmpty();
            this.open.setEnabled(oneOrMoreSelected);
            this.openWorkingTreeVersion.setEnabled(oneOrMoreSelected);
            this.compare.setEnabled(sel.size() == 1);
            this.blame.setEnabled(oneOrMoreSelected);
            if (sel.size() == 1) {
                FileDiff diff = (FileDiff)((Object)sel.getFirstElement());
                String path = new Path(this.getRepository().getWorkTree().getAbsolutePath()).append(diff.getPath()).toOSString();
                this.compareWorkingTreeVersion.setEnabled(new File(path).exists() && !submoduleSelected);
            } else {
                this.compareWorkingTreeVersion.setEnabled(false);
            }
        } else {
            this.open.setEnabled(false);
            this.openWorkingTreeVersion.setEnabled(false);
            this.compare.setEnabled(false);
            this.blame.setEnabled(false);
            this.compareWorkingTreeVersion.setEnabled(false);
        }
    }

    private IAction createStandardAction(final ActionFactory af) {
        final String text = af.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getText();
        Action action = new Action(){

            public String getActionDefinitionId() {
                return af.getCommandId();
            }

            public String getId() {
                return af.getId();
            }

            public String getText() {
                return text;
            }

            public void run() {
                if (af == ActionFactory.SELECT_ALL) {
                    CommitFileDiffViewer.this.doSelectAll();
                }
                if (af == ActionFactory.COPY) {
                    CommitFileDiffViewer.this.doCopy();
                }
            }
        };
        action.setEnabled(true);
        return action;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput == null && input == null) {
            return;
        }
        super.inputChanged(input, oldInput);
        this.revealFirstInterestingElement();
    }

    public ShowInContext getShowInContext() {
        if (this.db.isBare()) {
            return null;
        }
        Path workTreePath = new Path(this.db.getWorkTree().getAbsolutePath());
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object selectedElement : selection.toList()) {
            FileDiff fileDiff = (FileDiff)((Object)selectedElement);
            IPath path = workTreePath.append(fileDiff.getPath());
            IFile file = ResourceUtil.getFileForLocation((IPath)path);
            if (file != null) {
                elements.add(file);
                continue;
            }
            elements.add(path);
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(elements));
    }

    private void openFileInEditor(String filePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        File file = new File(filePath);
        if (!file.exists()) {
            String message = NLS.bind((String)UIText.CommitFileDiffViewer_FileDoesNotExist, (Object)filePath);
            Activator.showError(message, null);
        }
        IWorkbenchPage page = window.getActivePage();
        EgitUiEditorUtils.openEditor(file, page);
    }

    private void openFileInEditor(FileDiff d) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IFileRevision rev = CompareUtils.getFileRevision(d.getPath(), d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getCommit().getParent(0) : d.getCommit(), this.getRepository(), d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getBlobs()[0] : d.getBlobs()[d.getBlobs().length - 1]);
            if (rev != null) {
                EgitUiEditorUtils.openEditor(page, rev, (IProgressMonitor)new NullProgressMonitor());
            } else {
                String message = NLS.bind((String)UIText.CommitFileDiffViewer_notContainedInCommit, (Object)d.getPath(), (Object)d.getCommit().getId().getName());
                Activator.showError(message, null);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
        catch (CoreException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
    }

    private void showAnnotations(FileDiff d) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            RevCommit commit = d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getCommit().getParent(0) : d.getCommit();
            IFileRevision rev = CompareUtils.getFileRevision(d.getPath(), commit, this.getRepository(), d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getBlobs()[0] : d.getBlobs()[d.getBlobs().length - 1]);
            if (rev != null) {
                BlameOperation op = new BlameOperation(this.getRepository(), rev.getStorage((IProgressMonitor)new NullProgressMonitor()), d.getPath(), (AnyObjectId)commit, window.getShell(), page);
                JobUtil.scheduleUserJob((IEGitOperation)op, (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
            } else {
                String message = NLS.bind((String)UIText.CommitFileDiffViewer_notContainedInCommit, (Object)d.getPath(), (Object)d.getCommit().getId().getName());
                Activator.showError(message, null);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
        catch (CoreException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
    }

    void showTwoWayFileDiff(FileDiff d) {
        ObjectId rightObjectId;
        RevCommit rightCommit;
        ObjectId baseObjectId;
        RevCommit leftCommit;
        String p = d.getPath();
        RevCommit c = d.getCommit();
        if (d.getBlobs().length == 2 && !d.getChange().equals((Object)DiffEntry.ChangeType.ADD)) {
            leftCommit = c.getParent(0);
            baseObjectId = d.getBlobs()[0];
        } else {
            leftCommit = null;
            baseObjectId = null;
        }
        if (d.getChange().equals((Object)DiffEntry.ChangeType.DELETE)) {
            rightCommit = null;
            rightObjectId = null;
        } else {
            rightCommit = c;
            rightObjectId = d.getBlobs()[1];
        }
        IFile file = ResourceUtil.getFileForLocation((Repository)this.getRepository(), (String)p);
        if (file != null && leftCommit != null && rightCommit != null && !CompareUtils.canDirectlyOpenInCompare(file)) {
            try {
                GitModelSynchronize.synchronizeModelBetweenRefs(file, this.getRepository(), leftCommit.getName(), rightCommit.getName());
            }
            catch (Exception e) {
                Activator.logError(UIText.GitHistoryPage_openFailed, e);
                Activator.showError(UIText.GitHistoryPage_openFailed, null);
            }
            return;
        }
        ITypedElement base = this.createTypedElement(p, leftCommit, baseObjectId);
        ITypedElement next = this.createTypedElement(p, rightCommit, rightObjectId);
        CompareUtils.openInCompare(this.site.getWorkbenchWindow().getActivePage(), (CompareEditorInput)new GitCompareFileRevisionEditorInput(next, base, null));
    }

    private ITypedElement createTypedElement(String path, RevCommit commit, ObjectId objectId) {
        if (commit != null) {
            return CompareUtils.getFileRevisionTypedElement(path, commit, this.getRepository(), objectId);
        }
        return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
    }

    void showWorkingDirectoryFileDiff(FileDiff d) {
        String p = d.getPath();
        RevCommit commit = d.getCommit();
        ObjectId[] blobs = d.getBlobs();
        IFile file = ResourceUtil.getFileForLocation((Repository)this.getRepository(), (String)p);
        if (file != null && commit != null && !CompareUtils.canDirectlyOpenInCompare(file)) {
            try {
                GitModelSynchronize.synchronizeModelWithWorkspace(file, this.getRepository(), commit.getName());
            }
            catch (Exception e) {
                Activator.logError(UIText.GitHistoryPage_openFailed, e);
                Activator.showError(UIText.GitHistoryPage_openFailed, null);
            }
            return;
        }
        Object next = file != null ? SaveableCompareEditorInput.createFileElement((IFile)file) : new LocalNonWorkspaceTypedElement(new Path(this.getRepository().getWorkTree().getAbsolutePath()).append(p));
        GitCompareFileRevisionEditorInput.EmptyTypedElement base = d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? new GitCompareFileRevisionEditorInput.EmptyTypedElement("") : CompareUtils.getFileRevisionTypedElement(p, commit, this.getRepository(), blobs[blobs.length - 1]);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)next, base, null);
        CompareUtils.openInCompare(this.site.getWorkbenchWindow().getActivePage(), (CompareEditorInput)in);
    }

    TreeWalk getTreeWalk() {
        if (this.walker == null) {
            throw new IllegalStateException("TreeWalk has not been set");
        }
        return this.walker;
    }

    private Repository getRepository() {
        if (this.db == null) {
            throw new IllegalStateException("Repository has not been set");
        }
        return this.db;
    }

    public void setTreeWalk(Repository repository, TreeWalk walk) {
        this.db = repository;
        this.walker = walk;
    }

    private void doSelectAll() {
        Object in = this.getInput();
        if (in == null) {
            return;
        }
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Object[] el = cp.getElements(in);
        if (el == null || el.length == 0) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(el));
    }

    private void doCopy() {
        ISelection s = this.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            FileDiff d = (FileDiff)((Object)itr.next());
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(d.getPath());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInterestingPaths(Set<String> interestingPaths) {
        ((FileDiffContentProvider)this.getContentProvider()).setInterestingPaths(interestingPaths);
    }

    private void revealFirstInterestingElement() {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        Object[] elements = contentProvider.getElements(this.getInput());
        if (elements.length <= 1) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            FileDiff fileDiff;
            boolean marked;
            final Object element = objectArray[n2];
            if (element instanceof FileDiff && (marked = (fileDiff = (FileDiff)((Object)element)).isMarked(0))) {
                this.getTable().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CommitFileDiffViewer.this.reveal(element);
                    }
                });
                return;
            }
            ++n2;
        }
    }
}

