/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.DecorationOverlayDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilterMarker;
import org.eclipse.ui.model.WorkbenchAdapter;

public class FileDiff
extends WorkbenchAdapter {
    private final RevCommit commit;
    private DiffEntry diffEntry;

    private static ObjectId[] trees(RevCommit commit) {
        ObjectId[] r = new ObjectId[commit.getParentCount() + 1];
        int i = 0;
        while (i < r.length - 1) {
            r[i] = commit.getParent(i).getTree().getId();
            ++i;
        }
        r[r.length - 1] = commit.getTree().getId();
        return r;
    }

    public static FileDiff[] compute(TreeWalk walk, RevCommit commit, TreeFilter ... markTreeFilters) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<FileDiff> r = new ArrayList<FileDiff>();
        if (commit.getParentCount() > 0) {
            walk.reset((AnyObjectId[])FileDiff.trees(commit));
        } else {
            walk.reset();
            walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            walk.addTree((AnyObjectId)commit.getTree());
        }
        if (walk.getTreeCount() <= 2) {
            List entries = DiffEntry.scan((TreeWalk)walk, (boolean)false, (TreeFilter[])markTreeFilters);
            for (DiffEntry entry : entries) {
                FileDiff d = new FileDiff(commit, entry);
                r.add(d);
            }
        } else {
            int nTree = walk.getTreeCount();
            int myTree = nTree - 1;
            TreeFilterMarker treeFilterMarker = new TreeFilterMarker(markTreeFilters);
            while (walk.next()) {
                if (FileDiff.matchAnyParent(walk, myTree)) continue;
                int treeFilterMarks = treeFilterMarker.getMarks(walk);
                FileDiffForMerges d = new FileDiffForMerges(commit, treeFilterMarks);
                d.path = walk.getPathString();
                int m0 = 0;
                int i = 0;
                while (i < myTree) {
                    m0 |= walk.getRawMode(i);
                    ++i;
                }
                int m1 = walk.getRawMode(myTree);
                d.change = DiffEntry.ChangeType.MODIFY;
                if (m0 == 0 && m1 != 0) {
                    d.change = DiffEntry.ChangeType.ADD;
                } else if (m0 != 0 && m1 == 0) {
                    d.change = DiffEntry.ChangeType.DELETE;
                } else if (m0 != m1 && walk.idEqual(0, myTree)) {
                    d.change = DiffEntry.ChangeType.MODIFY;
                }
                d.blobs = new ObjectId[nTree];
                d.modes = new FileMode[nTree];
                int i2 = 0;
                while (i2 < nTree) {
                    ((FileDiffForMerges)d).blobs[i2] = walk.getObjectId(i2);
                    ((FileDiffForMerges)d).modes[i2] = walk.getFileMode(i2);
                    ++i2;
                }
                r.add(d);
            }
        }
        FileDiff[] tmp = new FileDiff[r.size()];
        r.toArray(tmp);
        return tmp;
    }

    private static boolean matchAnyParent(TreeWalk walk, int myTree) {
        int m = walk.getRawMode(myTree);
        int i = 0;
        while (i < myTree) {
            if (walk.getRawMode(i) == m && walk.idEqual(i, myTree)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void outputDiff(StringBuilder d, Repository db, DiffFormatter diffFmt, boolean gitFormat) throws IOException {
        if (gitFormat) {
            diffFmt.setRepository(db);
            diffFmt.format(this.diffEntry);
            return;
        }
        ObjectReader reader = db.newObjectReader();
        try {
            this.outputEclipseDiff(d, db, reader, diffFmt);
        }
        finally {
            reader.release();
        }
    }

    private void outputEclipseDiff(StringBuilder d, Repository db, ObjectReader reader, DiffFormatter diffFmt) throws IOException {
        if (this.getBlobs().length != 2) {
            throw new UnsupportedOperationException("Not supported yet if the number of parents is different from one");
        }
        String projectRelativePath = this.getProjectRelativePath(db, this.getPath());
        d.append("diff --git ").append(projectRelativePath).append(" ").append(projectRelativePath).append("\n");
        ObjectId id1 = this.getBlobs()[0];
        ObjectId id2 = this.getBlobs()[1];
        FileMode mode1 = this.getModes()[0];
        FileMode mode2 = this.getModes()[1];
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("new file mode " + mode2).append("\n");
        } else if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("deleted file mode " + mode1).append("\n");
        } else if (!mode1.equals(mode2)) {
            d.append("old mode " + mode1);
            d.append("new mode " + mode2).append("\n");
        }
        d.append("index ").append(reader.abbreviate((AnyObjectId)id1).name()).append("..").append(reader.abbreviate((AnyObjectId)id2).name()).append(mode1.equals(mode2) ? " " + mode1 : "").append("\n");
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("--- /dev/null\n");
        } else {
            d.append("--- ");
            d.append(this.getProjectRelativePath(db, this.getPath()));
            d.append("\n");
        }
        if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("+++ /dev/null\n");
        } else {
            d.append("+++ ");
            d.append(this.getProjectRelativePath(db, this.getPath()));
            d.append("\n");
        }
        RawText a = this.getRawText(id1, reader);
        RawText b = this.getRawText(id2, reader);
        EditList editList = MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b);
        diffFmt.format(editList, a, b);
    }

    private String getProjectRelativePath(Repository db, String repoPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath absolutePath = new Path(db.getWorkTree().getAbsolutePath()).append(repoPath);
        IFile resource = root.getFileForLocation(absolutePath);
        return resource.getProjectRelativePath().toString();
    }

    private RawText getRawText(ObjectId id, ObjectReader reader) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader ldr = reader.open((AnyObjectId)id, 3);
        return new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public String getPath() {
        if (DiffEntry.ChangeType.DELETE.equals((Object)this.diffEntry.getChangeType())) {
            return this.diffEntry.getOldPath();
        }
        return this.diffEntry.getNewPath();
    }

    public DiffEntry.ChangeType getChange() {
        return this.diffEntry.getChangeType();
    }

    public ObjectId[] getBlobs() {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        if (this.diffEntry.getOldId() != null) {
            objectIds.add(this.diffEntry.getOldId().toObjectId());
        }
        if (this.diffEntry.getNewId() != null) {
            objectIds.add(this.diffEntry.getNewId().toObjectId());
        }
        return objectIds.toArray(new ObjectId[0]);
    }

    public FileMode[] getModes() {
        ArrayList<FileMode> modes = new ArrayList<FileMode>();
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        return modes.toArray(new FileMode[0]);
    }

    public boolean isMarked(int index) {
        return this.diffEntry != null && this.diffEntry.isMarked(index);
    }

    public FileDiff(RevCommit c, DiffEntry entry) {
        this.diffEntry = entry;
        this.commit = c;
    }

    public boolean isSubmodule() {
        if (this.diffEntry == null) {
            return false;
        }
        return this.diffEntry.getOldMode() == FileMode.GITLINK || this.diffEntry.getNewMode() == FileMode.GITLINK;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor base = !this.isSubmodule() ? UIUtils.getEditorImage(this.getPath()) : UIIcons.REPOSITORY;
        switch (this.getChange()) {
            case ADD: {
                return new DecorationOverlayDescriptor(base, UIIcons.OVR_STAGED_ADD, 3);
            }
            case DELETE: {
                return new DecorationOverlayDescriptor(base, UIIcons.OVR_STAGED_REMOVE, 3);
            }
        }
        return base;
    }

    public String getLabel(Object object) {
        return this.getPath();
    }

    private static class FileDiffForMerges
    extends FileDiff {
        private String path;
        private DiffEntry.ChangeType change;
        private ObjectId[] blobs;
        private FileMode[] modes;
        private final int treeFilterMarks;

        private FileDiffForMerges(RevCommit c, int treeFilterMarks) {
            super(c, null);
            this.treeFilterMarks = treeFilterMarks;
        }

        public String getPath() {
            return this.path;
        }

        public DiffEntry.ChangeType getChange() {
            return this.change;
        }

        public ObjectId[] getBlobs() {
            return this.blobs;
        }

        public FileMode[] getModes() {
            return this.modes;
        }

        public boolean isMarked(int index) {
            return ((long)this.treeFilterMarks & 1L << index) != 0L;
        }
    }
}

