/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SelectResetTypePage
extends WizardPage {
    private ResetCommand.ResetType resetType = ResetCommand.ResetType.MIXED;
    private final Repository repo;
    private final String current;
    private final String target;

    public SelectResetTypePage(String repoName, Repository repository, String currentRef, String targetRef) {
        super(SelectResetTypePage.class.getName());
        this.setTitle(NLS.bind((String)UIText.SelectResetTypePage_PageTitle, (Object)repoName));
        this.setMessage(UIText.SelectResetTypePage_PageMessage);
        this.repo = repository;
        this.current = currentRef;
        this.target = targetRef;
    }

    private Image getIcon(String ref) {
        if (ref.startsWith("refs/tags/")) {
            return UIIcons.TAG.createImage();
        }
        if (ref.startsWith("refs/heads/") || ref.startsWith("refs/remotes/")) {
            return UIIcons.BRANCH.createImage();
        }
        return UIIcons.CHANGESET.createImage();
    }

    private boolean isCommit(String ref) {
        return !ref.startsWith("refs/");
    }

    private String formatCommit(RevCommit commit) {
        return String.valueOf(commit.abbreviate(7).name()) + ":  " + commit.getShortMessage();
    }

    private RevCommit getLatestCommit(String branch) {
        ObjectId resolved;
        try {
            resolved = this.repo.resolve(branch);
        }
        catch (IOException iOException) {
            return null;
        }
        if (resolved == null) {
            return null;
        }
        RevWalk walk = new RevWalk(this.repo);
        walk.setRetainBody(true);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)resolved);
            return revCommit;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            walk.release();
        }
    }

    public void createControl(Composite parent) {
        boolean resetToSelf;
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        RevCommit currentCommit = this.getLatestCommit(this.current);
        Label currentLabel = new Label(displayArea, 0);
        currentLabel.setText(UIText.SelectResetTypePage_labelCurrentHead);
        currentLabel.setToolTipText(UIText.SelectResetTypePage_tooltipCurrentHead);
        CLabel currentValue = new CLabel(displayArea, 0);
        GridDataFactory.swtDefaults().applyTo((Control)currentValue);
        Image currentIcon = this.getIcon(this.current);
        UIUtils.hookDisposal((Widget)currentValue, (Resource)currentIcon);
        currentValue.setImage(currentIcon);
        currentValue.setText(Repository.shortenRefName((String)this.current));
        if (currentCommit != null) {
            if (this.isCommit(this.current)) {
                currentValue.setText(this.formatCommit(currentCommit));
            } else {
                new Label(displayArea, 0);
                CLabel commitLabel = new CLabel(displayArea, 0);
                Image commitIcon = UIIcons.CHANGESET.createImage();
                UIUtils.hookDisposal((Widget)commitLabel, (Resource)commitIcon);
                commitLabel.setImage(commitIcon);
                commitLabel.setText(this.formatCommit(currentCommit));
            }
        }
        if (!(resetToSelf = this.current.equals(this.target))) {
            RevCommit targetCommit = this.getLatestCommit(this.target);
            Label targetLabel = new Label(displayArea, 0);
            targetLabel.setText(UIText.SelectResetTypePage_labelResettingTo);
            targetLabel.setToolTipText(UIText.SelectResetTypePage_tooltipResettingTo);
            CLabel targetValue = new CLabel(displayArea, 0);
            Image targetIcon = this.getIcon(this.target);
            UIUtils.hookDisposal((Widget)targetValue, (Resource)targetIcon);
            targetValue.setImage(targetIcon);
            targetValue.setText(Repository.shortenRefName((String)this.target));
            if (targetCommit != null) {
                if (this.isCommit(this.target)) {
                    targetValue.setText(this.formatCommit(targetCommit));
                } else {
                    new Label(displayArea, 0);
                    CLabel commitLabel = new CLabel(displayArea, 0);
                    Image commitIcon = UIIcons.CHANGESET.createImage();
                    UIUtils.hookDisposal((Widget)commitLabel, (Resource)commitIcon);
                    commitLabel.setImage(commitIcon);
                    commitLabel.setText(this.formatCommit(targetCommit));
                }
            }
        }
        Group g = new Group(displayArea, 0);
        g.setText(UIText.ResetTargetSelectionDialog_ResetTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).indent(0, 5).applyTo((Control)g);
        GridLayoutFactory.swtDefaults().applyTo((Composite)g);
        if (!resetToSelf) {
            Button soft = new Button((Composite)g, 16);
            soft.setText(UIText.ResetTargetSelectionDialog_ResetTypeSoftButton);
            soft.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        SelectResetTypePage.this.resetType = ResetCommand.ResetType.SOFT;
                    }
                }
            });
        }
        Button medium = new Button((Composite)g, 16);
        medium.setSelection(true);
        medium.setText(resetToSelf ? UIText.ResetTargetSelectionDialog_ResetTypeHEADMixedButton : UIText.ResetTargetSelectionDialog_ResetTypeMixedButton);
        medium.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    SelectResetTypePage.this.resetType = ResetCommand.ResetType.MIXED;
                }
            }
        });
        Button hard = new Button((Composite)g, 16);
        hard.setText(resetToSelf ? UIText.ResetTargetSelectionDialog_ResetTypeHEADHardButton : UIText.ResetTargetSelectionDialog_ResetTypeHardButton);
        hard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    SelectResetTypePage.this.resetType = ResetCommand.ResetType.HARD;
                }
            }
        });
        Dialog.applyDialogFont((Control)displayArea);
        this.setControl((Control)displayArea);
    }

    public ResetCommand.ResetType getResetType() {
        return this.resetType;
    }
}

