/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronizeParticipant;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GitModelSynchronize {
    private static final String GIT_PROVIDER_ID = "org.eclipse.egit.core.GitProvider";

    public static final void synchronizeModelWithWorkspace(IFile file, Repository repository, String refName) throws IOException {
        GitModelSynchronize.synchronizeModel(file, new GitSynchronizeData(repository, "HEAD", refName, true));
    }

    public static final void synchronizeModelBetweenRefs(IFile file, Repository repository, String sourceRef, String destinationRef) throws IOException {
        GitModelSynchronize.synchronizeModel(file, new GitSynchronizeData(repository, sourceRef, destinationRef, false));
    }

    private static void synchronizeModel(IFile file, GitSynchronizeData data) {
        GitSynchronizeDataSet dataSet = new GitSynchronizeDataSet(data);
        ResourceMapping[] mappings = ResourceUtil.getResourceMappings((IFile)file, (ResourceMappingContext)ResourceMappingContext.LOCAL_CONTEXT);
        GitModelSynchronize.launch(dataSet, mappings);
    }

    public static final void launch(GitSynchronizeData data, IResource[] resources) {
        GitModelSynchronize.launch(new GitSynchronizeDataSet(data), resources);
    }

    public static final void launch(GitSynchronizeDataSet gsdSet, IResource[] resources) {
        ResourceMapping[] mappings = GitModelSynchronize.getGitResourceMappings(resources);
        GitModelSynchronize.launch(gsdSet, mappings);
    }

    public static final void launch(GitSynchronizeDataSet gsdSet, ResourceMapping[] mappings) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        GitModelSynchronize.fireSynchronizeAction(window, gsdSet, mappings);
    }

    private static ResourceMapping[] getGitResourceMappings(IResource[] elements) {
        ArrayList<ResourceMapping> gitMappings = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt((Object)element, ResourceMapping.class);
            if (mapping != null && GitModelSynchronize.isMappedToGitProvider(mapping)) {
                gitMappings.add(mapping);
            }
            ++n2;
        }
        return gitMappings.toArray(new ResourceMapping[gitMappings.size()]);
    }

    private static boolean isMappedToGitProvider(ResourceMapping element) {
        IProject[] projects;
        IProject[] iProjectArray = projects = element.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null && provider.getID().equals(GIT_PROVIDER_ID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void fireSynchronizeAction(final IWorkbenchWindow window, final GitSynchronizeDataSet gsdSet, final ResourceMapping[] mappings) {
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(gsdSet);
        Job syncJob = new Job(UIText.GitModelSynchonize_fetchGitDataJobName){

            protected IStatus run(IProgressMonitor monitor) {
                subscriber.init(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.SYNCHRONIZE_READ_DATA.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        syncJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber, gsdSet);
                SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
                GitSubscriberMergeContext context = new GitSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager, gsdSet);
                GitModelSynchronizeParticipant participant = new GitModelSynchronizeParticipant(context);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
                IWorkbenchPart activePart = null;
                if (window != null) {
                    activePart = window.getActivePage().getActivePart();
                }
                participant.run(activePart);
            }
        });
        syncJob.setUser(true);
        syncJob.schedule();
    }

    private GitModelSynchronize() {
    }
}

