/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.egit.ui.internal.synchronize.model.TreeBuilder;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitModelCache
extends GitModelObjectContainer {
    private final Path location;
    private final Repository repo;
    private GitModelObject[] children;

    public GitModelCache(GitModelRepository parent, Repository repo, Map<String, GitCommitsModelCache.Change> cache) {
        this(parent, repo, cache, new TreeBuilder.FileModelFactory(){

            public GitModelBlob createFileModel(GitModelObjectContainer objParent, Repository nestedRepo, GitCommitsModelCache.Change change, IPath path) {
                return new GitModelCacheFile(objParent, nestedRepo, change, path);
            }

            public boolean isWorkingTree() {
                return false;
            }
        });
    }

    protected GitModelCache(GitModelRepository parent, final Repository repo, Map<String, GitCommitsModelCache.Change> changes, final TreeBuilder.FileModelFactory fileFactory) {
        super(parent);
        this.repo = repo;
        this.location = new Path(repo.getWorkTree().toString());
        this.children = TreeBuilder.build(this, repo, changes, fileFactory, new TreeBuilder.TreeModelFactory(){

            public GitModelTree createTreeModel(GitModelObjectContainer parentObject, IPath fullPath, int kind) {
                return new GitModelCacheTree(parentObject, repo, fullPath, fileFactory);
            }
        });
    }

    @Override
    public String getName() {
        return UIText.GitModelIndex_index;
    }

    @Override
    public GitModelObject[] getChildren() {
        return this.children;
    }

    @Override
    public int getKind() {
        return 11;
    }

    @Override
    public int repositoryHashCode() {
        return this.repo.getWorkTree().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitModelCache && !(obj instanceof GitModelWorkingTree)) {
            GitModelCache left = (GitModelCache)((Object)obj);
            return ((Object)((Object)left.getParent())).equals((Object)this.getParent());
        }
        return false;
    }

    public int hashCode() {
        return this.repositoryHashCode();
    }

    @Override
    public IPath getLocation() {
        return this.location;
    }

    public String toString() {
        return "ModelCache";
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            GitModelObject[] gitModelObjectArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                GitModelObject object = gitModelObjectArray[n2];
                object.dispose();
                ++n2;
            }
            this.children = null;
        }
    }
}

