/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationIndication
extends IndicationWithMonitoring {
    private byte[] randomToken;

    public AuthenticationIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)2);
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }

    protected InternalCDOSession getSession() {
        return (InternalCDOSession)this.getProtocol().getSession();
    }

    protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.randomToken = in.readByteArray();
    }

    protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            CDOAuthenticator authenticator = this.getSession().getAuthenticator();
            if (authenticator == null) {
                throw new IllegalStateException("No authenticator configured");
            }
            CDOAuthenticationResult result = authenticator.authenticate(this.randomToken);
            if (result == null) {
                out.writeBoolean(false);
                return;
            }
            try {
                String userID = result.getUserID();
                if (userID == null) {
                    throw new SecurityException("No user ID");
                }
                byte[] cryptedToken = result.getCryptedToken();
                if (cryptedToken == null) {
                    throw new SecurityException("No crypted token");
                }
                out.writeBoolean(true);
                result.write((ExtendedDataOutput)out);
            }
            catch (Exception ex) {
                out.writeBoolean(false);
                throw ex;
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

