/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadMergeDataRequest
extends CDOClientRequestWithMonitoring<Set<CDOID>> {
    private CDORevisionAvailabilityInfo targetInfo;
    private CDORevisionAvailabilityInfo sourceInfo;
    private CDORevisionAvailabilityInfo targetBaseInfo;
    private CDORevisionAvailabilityInfo sourceBaseInfo;
    private int infos;

    public LoadMergeDataRequest(CDOClientProtocol protocol, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        super(protocol, (short)45);
        this.targetInfo = targetInfo;
        this.sourceInfo = sourceInfo;
        this.targetBaseInfo = targetBaseInfo;
        this.sourceBaseInfo = sourceBaseInfo;
        this.infos = 2 + (targetBaseInfo != null ? 1 : 0) + (sourceBaseInfo != null ? 1 : 0);
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeInt(this.infos);
        monitor.begin((double)this.infos);
        try {
            this.writeRevisionAvailabilityInfo(out, this.targetInfo, monitor.fork());
            this.writeRevisionAvailabilityInfo(out, this.sourceInfo, monitor.fork());
            if (this.infos > 2) {
                this.writeRevisionAvailabilityInfo(out, this.targetBaseInfo, monitor.fork());
            }
            if (this.infos > 3) {
                this.writeRevisionAvailabilityInfo(out, this.sourceBaseInfo, monitor.fork());
            }
        }
        finally {
            monitor.done();
        }
    }

    private void writeRevisionAvailabilityInfo(CDODataOutput out, CDORevisionAvailabilityInfo info, OMMonitor monitor) throws IOException {
        Set availableRevisions = info.getAvailableRevisions().keySet();
        int size = availableRevisions.size();
        out.writeCDOBranchPoint(info.getBranchPoint());
        out.writeInt(size);
        monitor.begin((double)size);
        try {
            for (CDOID id : availableRevisions) {
                out.writeCDOID(id);
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected Set<CDOID> confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        HashSet<CDOID> result = new HashSet<CDOID>();
        int size = in.readInt();
        monitor.begin((double)(size + this.infos));
        try {
            int i = 0;
            while (i < size) {
                CDOID id = in.readCDOID();
                result.add(id);
                monitor.worked();
                ++i;
            }
            this.readRevisionAvailabilityInfo(in, this.targetInfo, result, monitor.fork());
            this.readRevisionAvailabilityInfo(in, this.sourceInfo, result, monitor.fork());
            if (this.infos > 2) {
                this.readRevisionAvailabilityInfo(in, this.targetBaseInfo, result, monitor.fork());
            }
            if (this.infos > 3) {
                this.readRevisionAvailabilityInfo(in, this.sourceBaseInfo, result, monitor.fork());
            }
            HashSet<CDOID> hashSet = result;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    private void readRevisionAvailabilityInfo(CDODataInput in, CDORevisionAvailabilityInfo info, Set<CDOID> result, OMMonitor monitor) throws IOException {
        int size = in.readInt();
        monitor.begin((double)(size + 1));
        try {
            int i = 0;
            while (i < size) {
                CDORevision revision;
                if (in.readBoolean()) {
                    revision = in.readCDORevision();
                } else {
                    CDORevisionKey key = in.readCDORevisionKey();
                    revision = this.getRevision(key, this.targetInfo);
                    if (revision == null && this.sourceInfo != null) {
                        revision = this.getRevision(key, this.sourceInfo);
                    }
                    if (revision == null && this.targetBaseInfo != null) {
                        revision = this.getRevision(key, this.targetBaseInfo);
                    }
                    if (revision == null) {
                        throw new IllegalStateException("Missing revision: " + key);
                    }
                }
                info.addRevision((CDORevisionKey)revision);
                monitor.worked();
                ++i;
            }
            Set entrySet = info.getAvailableRevisions().entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (result.contains(entry.getKey())) continue;
                it.remove();
            }
            monitor.worked();
        }
        finally {
            monitor.done();
        }
    }

    private CDORevision getRevision(CDORevisionKey key, CDORevisionAvailabilityInfo info) {
        CDORevision revision = info.getRevision(key.getID());
        if (revision instanceof CDORevision && key.equals(revision)) {
            return revision;
        }
        return null;
    }
}

