/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServerRepository;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.server.internal.admin.protocol.CDOAdminServerProtocol;
import org.eclipse.emf.cdo.server.spi.admin.CDOAdminHandler;
import org.eclipse.emf.cdo.spi.common.admin.AbstractCDOAdmin;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdminServer
extends AbstractCDOAdmin {
    private final IManagedContainer container;
    private final IListener containerListener = new ContainerEventAdapter<Object>(){

        protected void onAdded(IContainer<Object> container, Object element) {
            if (element instanceof IRepository) {
                IRepository repository = (IRepository)element;
                CDOAdminServer.this.repositoryAdded(repository);
            }
        }

        protected void onRemoved(IContainer<Object> container, Object element) {
            if (element instanceof IRepository) {
                IRepository repository = (IRepository)element;
                CDOAdminServer.this.removeRepository(repository);
            }
        }
    };
    private final Set<CDOAdminServerProtocol> protocols = new HashSet<CDOAdminServerProtocol>();

    public CDOAdminServer(IManagedContainer container, long timeout) {
        super(timeout);
        this.container = container;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProtocol(final CDOAdminServerProtocol protocol) {
        protocol.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                protocol.deactivate();
            }
        });
        Set<CDOAdminServerProtocol> set = this.protocols;
        synchronized (set) {
            this.protocols.add(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterProtocol(CDOAdminServerProtocol protocol) {
        Set<CDOAdminServerProtocol> set = this.protocols;
        synchronized (set) {
            this.protocols.remove((Object)protocol);
        }
    }

    protected boolean doCreateRepository(String name, String type, Map<String, Object> properties) {
        CDOAdminHandler handler = this.getAdminHandler(type);
        IRepository delegate = handler.createRepository(name, properties);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)delegate);
        return true;
    }

    protected boolean doDeleteRepository(String name, String type) {
        CDOAdminHandler handler = this.getAdminHandler(type);
        CDOAdminServerRepository repository = (CDOAdminServerRepository)this.getRepository(name);
        if (repository == null) {
            return false;
        }
        IRepository delegate = repository.getDelegate();
        LifecycleUtil.deactivate((Object)delegate);
        handler.deleteRepository(delegate);
        return true;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        Object[] objectArray = this.container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IRepository) {
                IRepository delegate = (IRepository)element;
                CDOAdminServerRepository repository = new CDOAdminServerRepository(this, delegate);
                this.addElement((Object)repository);
            }
            ++n2;
        }
        this.container.addListener(this.containerListener);
    }

    protected void doDeactivate() throws Exception {
        this.container.removeListener(this.containerListener);
        super.doDeactivate();
    }

    protected void repositoryAdded(IRepository delegate) {
        CDOAdminServerRepository repository = new CDOAdminServerRepository(this, delegate);
        if (this.addElement((Object)repository)) {
            CDOAdminServerProtocol[] cDOAdminServerProtocolArray = this.getProtocols();
            int n = cDOAdminServerProtocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdminServerProtocol protocol = cDOAdminServerProtocolArray[n2];
                try {
                    protocol.sendRepositoryAdded(repository);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(protocol, ex);
                }
                ++n2;
            }
        }
    }

    protected void removeRepository(IRepository delegate) {
        String name = delegate.getName();
        CDOAdminServerRepository repository = (CDOAdminServerRepository)this.getRepository(name);
        if (this.removeElement((Object)repository)) {
            repository.dispose();
            CDOAdminServerProtocol[] cDOAdminServerProtocolArray = this.getProtocols();
            int n = cDOAdminServerProtocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdminServerProtocol protocol = cDOAdminServerProtocolArray[n2];
                try {
                    protocol.sendRepositoryRemoved(name);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(protocol, ex);
                }
                ++n2;
            }
        }
    }

    protected void repositoryTypeChanged(String name, CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        CDOAdminServerProtocol[] cDOAdminServerProtocolArray = this.getProtocols();
        int n = cDOAdminServerProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminServerProtocol protocol = cDOAdminServerProtocolArray[n2];
            try {
                protocol.sendRepositoryTypeChanged(name, oldType, newType);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(protocol, ex);
            }
            ++n2;
        }
    }

    protected void repositoryStateChanged(String name, CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        CDOAdminServerProtocol[] cDOAdminServerProtocolArray = this.getProtocols();
        int n = cDOAdminServerProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminServerProtocol protocol = cDOAdminServerProtocolArray[n2];
            try {
                protocol.sendRepositoryStateChanged(name, oldState, newState);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(protocol, ex);
            }
            ++n2;
        }
    }

    protected void repositoryReplicationProgressed(String name, double totalWork, double work) {
        CDOAdminServerProtocol[] cDOAdminServerProtocolArray = this.getProtocols();
        int n = cDOAdminServerProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminServerProtocol protocol = cDOAdminServerProtocolArray[n2];
            try {
                protocol.sendRepositoryReplicationProgressed(name, totalWork, work);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(protocol, ex);
            }
            ++n2;
        }
    }

    protected void handleNotificationProblem(CDOAdminServerProtocol protocol, Exception ex) {
        OM.LOG.warn("A problem occured while notifying client " + (Object)((Object)protocol), (Throwable)ex);
    }

    protected CDOAdminHandler getAdminHandler(String type) {
        return (CDOAdminHandler)this.container.getElement("org.eclipse.emf.cdo.server.admin.adminHandlers", type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CDOAdminServerProtocol[] getProtocols() {
        Set<CDOAdminServerProtocol> set = this.protocols;
        synchronized (set) {
            return this.protocols.toArray(new CDOAdminServerProtocol[this.protocols.size()]);
        }
    }

    public static class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.admin.adminServers";
        public static final String TYPE = "default";
        private final IManagedContainer container;
        private final long timeout;

        public Factory(IManagedContainer container) {
            this(container, 10000L);
        }

        public Factory(IManagedContainer container, long timeout) {
            super(PRODUCT_GROUP, TYPE);
            this.container = container;
            this.timeout = timeout;
        }

        public final IManagedContainer getContainer() {
            return this.container;
        }

        public final long getTimeout() {
            return this.timeout;
        }

        public CDOAdminServer create(String description) {
            return new CDOAdminServer(this.container, this.timeout);
        }

        public static CDOAdminServer get(IManagedContainer container, String description) {
            return (CDOAdminServer)((Object)container.getElement(PRODUCT_GROUP, TYPE, description));
        }

        public static final class Plugin
        extends Factory {
            public Plugin() {
                super((IManagedContainer)IPluginContainer.INSTANCE);
            }
        }
    }
}

