/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeTable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalMappingStrategy
extends AbstractMappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalMappingStrategy.class);
    private IObjectTypeMapper objectTypeMapper;

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeMapper.getObjectType(accessor, id);
    }

    public void putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        this.objectTypeMapper.putObjectType(accessor, timeStamp, id, type);
    }

    @Override
    public void repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        IDBStore store = this.getStore();
        if (store.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            IIDHandler idHandler = store.getIDHandler();
            CDOID minLocalID = this.getMinLocalID(connection);
            idHandler.setNextLocalObjectID(minLocalID);
            CDOID maxID = this.objectTypeMapper.getMaxID(connection, idHandler);
            idHandler.setLastObjectID(maxID);
        }
    }

    @Override
    public void queryResources(IDBStoreAccessor accessor, IStoreAccessor.QueryResourcesContext context) {
        if (context.getTimeStamp() != 0L && !this.hasAuditSupport()) {
            throw new IllegalArgumentException("Mapping Strategy does not support audits");
        }
        EresourcePackage resourcesPackage = EresourcePackage.eINSTANCE;
        IClassMapping resourceFolder = this.getClassMapping(resourcesPackage.getCDOResourceFolder());
        boolean shallContinue = this.queryResources(accessor, resourceFolder, context);
        if (shallContinue) {
            IClassMapping resource = this.getClassMapping(resourcesPackage.getCDOResource());
            this.queryResources(accessor, resource, context);
        }
    }

    @Override
    public void queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context) {
        IIDHandler idHandler = this.getStore().getIDHandler();
        StringBuilder builder = null;
        for (CDOID targetID : context.getTargetObjects().keySet()) {
            if (builder == null) {
                builder = new StringBuilder("(");
            } else {
                builder.append(",");
            }
            idHandler.appendCDOID(builder, targetID);
        }
        builder.append(")");
        String idString = builder.toString();
        for (EClass eClass : context.getSourceCandidates().keySet()) {
            IClassMapping classMapping = this.getClassMapping(eClass);
            boolean more = classMapping.queryXRefs(accessor, context, idString);
            if (more) continue;
            return;
        }
    }

    @Override
    public void rawExport(IDBStoreAccessor accessor, CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE a_t.");
        builder.append("cdo_created");
        builder.append(" BETWEEN ");
        builder.append(fromCommitTime);
        builder.append(" AND ");
        builder.append(toCommitTime);
        String attrSuffix = builder.toString();
        Connection connection = accessor.getConnection();
        Collection<IClassMapping> classMappings = this.getClassMappings(true).values();
        out.writeInt(classMappings.size());
        for (IClassMapping classMapping : classMappings) {
            EClass eClass = classMapping.getEClass();
            out.writeCDOClassifierRef((EClassifier)eClass);
            IDBTable table = classMapping.getDBTables().get(0);
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"a_t", (String)attrSuffix);
            for (IListMapping listMapping : classMapping.getListMappings()) {
                this.rawExportList(out, connection, listMapping, table, attrSuffix);
            }
        }
        this.objectTypeMapper.rawExport(connection, out, fromCommitTime, toCommitTime);
    }

    protected void rawExportList(CDODataOutput out, Connection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        for (IDBTable table : listMapping.getDBTables()) {
            String listSuffix = ", " + attrTable + " \"a_t\"" + attrSuffix;
            String listJoin = this.getListJoinForRawExport("\"a_t\"", "\"l_t\"");
            if (listJoin != null) {
                listSuffix = String.valueOf(listSuffix) + listJoin;
            }
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"\"l_t\"", (String)listSuffix);
        }
    }

    protected String getListJoinForRawExport(String attrTable, String listTable) {
        return this.getListJoin(attrTable, listTable);
    }

    @Override
    public void rawImport(IDBStoreAccessor accessor, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return;
        }
        int objectTypeMapperWork = 10;
        monitor.begin((double)(3 * size + objectTypeMapperWork));
        try {
            Connection connection = accessor.getConnection();
            int i = 0;
            while (i < size) {
                EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                IClassMapping classMapping = this.getClassMapping(eClass);
                IDBTable table = classMapping.getDBTables().get(0);
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork());
                this.rawImportReviseOldRevisions(connection, table, monitor.fork());
                this.rawImportUnreviseNewRevisions(connection, table, fromCommitTime, toCommitTime, monitor.fork());
                List<IListMapping> listMappings = classMapping.getListMappings();
                int listSize = listMappings.size();
                if (listSize == 0) {
                    monitor.worked();
                } else {
                    OMMonitor listMonitor = monitor.fork();
                    listMonitor.begin((double)listSize);
                    try {
                        for (IListMapping listMapping : listMappings) {
                            this.rawImportList(in, connection, listMapping, listMonitor.fork());
                        }
                    }
                    finally {
                        listMonitor.done();
                    }
                }
                ++i;
            }
            this.objectTypeMapper.rawImport(connection, in, monitor.fork((double)objectTypeMapperWork));
        }
        finally {
            monitor.done();
        }
    }

    protected void rawImportUnreviseNewRevisions(Connection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportReviseOldRevisions(Connection connection, IDBTable table, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportList(CDODataInput in, Connection connection, IListMapping listMapping, OMMonitor monitor) throws IOException {
        Collection<IDBTable> tables = listMapping.getDBTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        monitor.begin((double)size);
        try {
            for (IDBTable table : tables) {
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork(), (DBUtil.DeserializeRowHandler)this.getImportListHandler());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected DBUtil.DeserializeRowHandler getImportListHandler() {
        return null;
    }

    @Override
    public String getListJoin(String attrTable, String listTable) {
        return " AND " + attrTable + "." + "cdo_id" + "=" + listTable + "." + "cdo_source";
    }

    @Override
    protected boolean isMapped(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    @Override
    protected Collection<EClass> getClassesWithObjectInfo() {
        return this.getClassMappings().keySet();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeMapper == null) {
            this.objectTypeMapper = this.createObjectTypeMapper();
        }
        LifecycleUtil.activate((Object)this.objectTypeMapper);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeMapper);
        super.doDeactivate();
    }

    private IObjectTypeMapper createObjectTypeMapper() {
        ObjectTypeTable table = new ObjectTypeTable();
        table.setMappingStrategy(this);
        int cacheSize = this.getObjectTypeCacheSize();
        if (cacheSize == 0) {
            return table;
        }
        ObjectTypeCache cache = new ObjectTypeCache(cacheSize);
        cache.setMappingStrategy(this);
        cache.setDelegate(table);
        return cache;
    }

    private int getObjectTypeCacheSize() {
        int objectTypeCacheSize = 100000;
        String value = this.getProperties().get("objectTypeCacheSize");
        if (value != null) {
            try {
                int intValue;
                objectTypeCacheSize = intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                OM.LOG.warn("Malformed configuration option for object type cache size. Using default.");
            }
        }
        return objectTypeCacheSize;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean queryResources(IDBStoreAccessor accessor, IClassMapping classMapping, IStoreAccessor.QueryResourcesContext context) {
        idHandler = this.getStore().getIDHandler();
        stmt = null;
        resultSet = null;
        folderID = context.getFolderID();
        name = context.getName();
        exactMatch = context.exactMatch();
        try {
            stmt = classMapping.createResourceQueryStatement(accessor, folderID, name, exactMatch, (CDOBranchPoint)context);
            resultSet = stmt.executeQuery();
            ** GOTO lbl-1000
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable var11_12) {
                DBUtil.close(resultSet);
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw var11_12;
            }
        }
lbl19:
        // 1 sources

        while (true) {
            DBUtil.close((ResultSet)resultSet);
            accessor.getStatementCache().releasePreparedStatement(stmt);
            return false;
        }
lbl-1000:
        // 2 sources

        {
            ** while (resultSet.next())
        }
lbl-1000:
        // 1 sources

        {
            id = idHandler.getCDOID(resultSet, 1);
            if (AbstractHorizontalMappingStrategy.TRACER.isEnabled()) {
                AbstractHorizontalMappingStrategy.TRACER.trace("Resource query returned ID " + id);
            }
            if (context.addResource(id)) continue;
            ** continue;
lbl30:
            // 1 sources

            ** GOTO lbl19
        }
lbl31:
        // 1 sources

        DBUtil.close((ResultSet)resultSet);
        accessor.getStatementCache().releasePreparedStatement(stmt);
        return true;
    }

    private CDOID getMinLocalID(Connection connection) {
        IIDHandler idHandler = this.getStore().getIDHandler();
        CDOID min = idHandler.getMaxCDOID();
        String dbName = this.getStore().getRepository().getName();
        List names = DBUtil.getAllTableNames((Connection)connection, (String)dbName);
        String prefix = "SELECT MIN(\"t\".cdo_id) FROM " + dbName + "." + "cdo_objects" + " \"o\", " + dbName + ".";
        String suffix = " \"t\" WHERE \"t\".cdo_branch<0 AND \"t\".cdo_id=\"o\".cdo_id AND \"t\".cdo_created=\"o\".cdo_created";
        for (String name : names) {
            Statement stmt = null;
            ResultSet resultSet = null;
            try {
                try {
                    CDOID id;
                    stmt = connection.createStatement();
                    resultSet = stmt.executeQuery(String.valueOf(prefix) + name + suffix);
                    if (resultSet.next() && (id = idHandler.getCDOID(resultSet, 1)) != null && idHandler.compare(id, min) < 0) {
                        min = id;
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    continue;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
        return min;
    }
}

