/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;

public class AuditListTableMapping
extends AbstractListTableMapping {
    private AbstractListTableMapping.FieldInfo[] keyFields;
    private String sqlClear;

    public AuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_version");
        builder.append("=? ");
        this.sqlClear = builder.toString();
    }

    protected AbstractListTableMapping.FieldInfo[] getKeyFields() {
        if (this.keyFields == null) {
            this.keyFields = new AbstractListTableMapping.FieldInfo[]{new AbstractListTableMapping.FieldInfo("cdo_source", this.getMappingStrategy().getStore().getIDHandler().getDBType()), new AbstractListTableMapping.FieldInfo("cdo_version", DBType.INTEGER)};
        }
        return this.keyFields;
    }

    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, revision.getID());
        stmt.setInt(2, revision.getVersion());
    }

    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
    }

    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlClear, IPreparedStatementCache.ReuseProbability.HIGH);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, id);
                stmt.setInt(2, version);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }
}

