/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;

public class StoreAccessorPool {
    private IStore store;
    private Object context;
    private ConcurrentLinkedQueue<StoreAccessorBase> accessors = new ConcurrentLinkedQueue();

    public StoreAccessorPool(IStore store, Object context) {
        this.store = store;
        this.context = context;
    }

    public IStore getStore() {
        return this.store;
    }

    public Object getContext() {
        return this.context;
    }

    public void addStoreAccessor(StoreAccessorBase storeAccessor) {
        try {
            storeAccessor.doPassivate();
            this.accessors.add(storeAccessor);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public StoreAccessorBase removeStoreAccessor(Object context) {
        StoreAccessorBase accessor = this.accessors.poll();
        if (accessor != null) {
            try {
                accessor.doUnpassivate();
                accessor.setContext(context);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                return null;
            }
        }
        return accessor;
    }

    public void dispose() {
        StoreAccessorBase accessor;
        while ((accessor = this.accessors.poll()) != null) {
            LifecycleUtil.deactivate((Object)accessor, (OMLogger.Level)OMLogger.Level.WARN);
        }
        this.context = null;
        this.store = null;
    }
}

